% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tablen.R
\name{table.n}
\alias{table.n}
\title{Cross Tabulation and Table Creation (including empty classes)}
\usage{
table.n(x, m = max(x, na.rm = TRUE), percentage = FALSE, weight = NULL,
  parallel = FALSE)
}
\arguments{
\item{x}{R object with classes}

\item{m}{maximum number of classes}

\item{percentage}{boolean. If TRUE result is in percentages.}

\item{weight}{weight for each voxel}

\item{parallel}{Logical. Can we use parallel computing?}
}
\value{
vector with (weighted) counts (including empty classes)
}
\description{
Cross Tabulation and Table Creation (including empty classes)
}
\examples{
x <- c(1,1,2,2,4,4,4)
table.n(x)
# [1] 2 2 0 3
table.n(x, m=5)
# [1] 2 2 0 3 0
table.n(x, weight=c(1,1,1,2,.5,.5,.5))
# [1] 2.0 3.0 0.0 1.5

}
\author{
Volker Schmid 2013-2016
}
