% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utils.R
\name{is.genome.available}
\alias{is.genome.available}
\title{Check Genome Availability}
\usage{
is.genome.available(organism, details = FALSE, database = "refseq")
}
\arguments{
\item{organism}{a character string specifying the scientific name of the organism of interest, e.g. 'Arabidopsis thaliana'.}

\item{details}{a logical value specifying whether or not details on genome size, kingdom, etc. shall be printed to the
console intead of a boolean value.}

\item{database}{a character string specifying the database for which genome availability shall be checked,
e.g. \code{database} =  \code{"refseq"} or \code{database} =  \code{"all"}.}
}
\value{
a logical value specifing whether or not the genome of the input organism
is available. In case \code{details} = \code{TRUE} only a character string specifying the
genome details is being returned.
}
\description{
This function checks the availability of a given genome on the NBCI servers specified
as scientific name.
}
\details{
Internally this function calls the \code{\link{listGenomes}} function to detect all available genomes
and checks whether or not the specified organism is available for download.
}
\examples{
\dontrun{

# checking whether the Arabidopsis thaliana genome is stored on NCBI
is.genome.available(organism = "Arabidopsis thaliana")

# and printing details
is.genome.available(organism = "Arabidopsis thaliana", details = TRUE)

}
}
\author{
Hajk-Georg Drost
}
\references{
\url{ftp://ftp.ncbi.nlm.nih.gov/genomes/GENOME_REPORTS/overview.txt}
}

