% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.retrieval.all.R
\name{meta.retrieval.all}
\alias{meta.retrieval.all}
\title{Perform Meta-Genome Retieval of all organisms in all kingdoms of life}
\usage{
meta.retrieval.all(db = "refseq", type = "genome")
}
\arguments{
\item{db}{a character string specifying the database from which the genome shall be retrieved: \code{db = "refseq"}, \code{db = "genbank"}, \code{db = "emsembl"} or \code{db = "ensemblgenomes"}.}

\item{type}{type of sequences that shall be retrieved. Options are:
\code{type = "genome"} (for genome assembly retrieval; see also \code{\link{getGenome}}), \code{type = "proteome"} (for proteome retrieval; see also \code{\link{getProteome}}),
\code{type = "CDS"} (for coding sequence retrieval; see also \code{\link{getCDS}}),
\code{type = "gff"} (for annotation file retrieval in gff format; see also \code{\link{getGFF}}),
\code{type = "assemblystats"} (for genome assembly quality stats file retrieval; see also \code{\link{getAssemblyStats}}).}
}
\description{
Download genomes, proteomes, or CDS of individual species of all kingdoms of life.
}
\details{
This function aims to perform bulk retrieval of all genomes of species
for all kingdoms of life.
}
\examples{
\dontrun{
# download all genomes from refseq
meta.retrieval.all(db = "refseq", type = "genome")

# download all vertebrate genomes from genbank
meta.retrieval.all(db = "genbank", type = "genome")

# download all vertebrate genomes from ensemblgenomes
meta.retrieval.all(db = "genbank", type = "ensemblgenomes")
}
}
\author{
Hajk-Georg Drost
}
