% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_VariablesImportance.R
\name{bm_VariablesImportance}
\alias{bm_VariablesImportance}
\title{Variables' importance calculation}
\usage{
bm_VariablesImportance(
  bm.model,
  expl.var,
  variables = NULL,
  method = "full_rand",
  nb.rep = 1,
  seed.val = NULL,
  do.progress = TRUE,
  ...
)
}
\arguments{
\item{bm.model}{a \code{biomod2_model} object (or \code{nnet}, \code{rpart}, \code{fda}, 
\code{gam}, \code{glm}, \code{lm}, \code{gbm}, \code{mars}, \code{randomForest}), \code{xgb.Booster} that can be 
obtained with the \code{\link{get_formal_model}} function}

\item{expl.var}{a \code{data.frame} containing the explanatory variables that will be used to 
compute the variables importance}

\item{variables}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing the names of the explanatory variables that will be considered}

\item{method}{a \code{character} corresponding to the randomisation method to be used, must be 
\code{full_rand} (\emph{only method available so far})}

\item{nb.rep}{an \code{integer} corresponding to the number of permutations to be done for 
each variable}

\item{seed.val}{(\emph{optional, default} \code{NULL}) \cr 
An \code{integer} value corresponding to the new seed value to be set}

\item{do.progress}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether the progress bar is to be rendered or not}

\item{...}{additional arguments}
}
\value{
A \code{3} columns \code{data.frame} containing variable's importance scores for each 
permutation run :
\itemize{
  \item{\code{expl.var}}{ : the considered explanatory variable (the one permuted)}
  \item{\code{rand}}{ : the ID of the permutation run}
  \item{\code{var.imp}}{ : the variable's importance score}
}
}
\description{
This internal \pkg{biomod2} function allows the user to compute a variable 
importance value for each variable involved in the given model.
}
\details{
For each variable to be evaluated :
\enumerate{
  \item shuffle the original variable
  \item compute model prediction with shuffled variable
  \item calculate Pearson's correlation between reference and shuffled predictions
  \item return score as \code{1 - cor}
}
The highest the value, the less reference and shuffled predictions are correlated, and the 
more influence the variable has on the model. A value of \code{0} assumes no influence of 
the variable on the model.

\emph{Note that this calculation does not account for variables' interactions.}

The same principle is used in \code{\link[randomForest]{randomForest}}.
}
\examples{

## Create simple simulated data
myResp.s <- sample(c(0, 1), 20, replace = TRUE)
myExpl.s <- data.frame(var1 = sample(c(0, 1), 100, replace = TRUE),
                       var2 = rnorm(100),
                       var3 = 1:100)

## Compute variables importance
mod <- glm(var1 ~ var2 + var3, data = myExpl.s)
bm_VariablesImportance(bm.model = mod, 
                       expl.var = myExpl.s[, c('var2', 'var3')],
                       method = "full_rand",
                       nb.rep = 3)


}
\seealso{
\code{\link[randomForest]{randomForest}}, 
\code{\link{bm_RunModelsLoop}}, \code{\link{BIOMOD_Modeling}}, 
\code{\link{BIOMOD_EnsembleModeling}}, \code{\link{bm_PlotVarImpBoxplot}}, 
\code{\link{get_variables_importance}}

Other Secundary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CVnnet}()},
\code{\link{bm_CrossValidation}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()}
}
\author{
Damien Georges
}
\concept{Secundary functions}
\keyword{"Pearson}
\keyword{correlation"}
\keyword{importance}
\keyword{random}
\keyword{shuffle}
