% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proximityFilter.R
\name{proximityFilter}
\alias{proximityFilter}
\title{Proximity-based exclusion}
\usage{
proximityFilter(centers, coordinates, radius = "auto")
}
\arguments{
\item{centers}{center coordinates of objects (mx|my|value data frame)}

\item{coordinates}{all coordinates of the objects (x|y|value data frame)}

\item{radius}{distance from one center in which no other centers
are allowed (in pixels)}
}
\value{
list of 3 objects:
\enumerate{
\item center coordinates of remaining objects
\item all coordinates of remaining objects
\item size of remaining objects
}
}
\description{
To detect objects within a defined range of one another, it is necessary to
calculate their centers to determine proximity. Pairs that are too close
will be discarded. (Input can be obtained by objectDetection function)
}
\examples{
res_objectDetection <- objectDetection(beads, alpha = 1, sigma = 2)
res_proximityFilter <- proximityFilter(
  res_objectDetection$centers,
  res_objectDetection$coordinates,
  radius = "auto"
  )
changePixelColor(
  beads,
  res_proximityFilter$coordinates,
  color = "darkgreen",
  visualize = TRUE
  )
}
