% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_string_operation.R
\name{seq_extract_position}
\alias{seq_extract_position}
\title{Extract a region between two positions in sequences}
\usage{
seq_extract_position(x, position_in, position_out)
}
\arguments{
\item{x}{a DNA, RNA or AA vector.}

\item{position_in}{an integer giving the position where to start to extract.}

\item{position_out}{an integer giving the position where to stop to extract.}
}
\value{
A vector of same class as \code{x}.
}
\description{
Extract a region between two positions in sequences
}
\examples{

x <- dna("ACGTTAGTGTAGCCGT", "CTCGAAATGA")
seq_extract_position(x, 3, 8)

}
\seealso{
\code{\link[stringi]{stri_extract}} from \pkg{stringi} and
\code{\link[stringr]{str_extract}} from \pkg{stringr}
for the underlying implementation.

Other string operations: 
\code{\link{seq-replace}},
\code{\link{seq_combine}()},
\code{\link{seq_count_pattern}()},
\code{\link{seq_crop_pattern}()},
\code{\link{seq_crop_position}()},
\code{\link{seq_detect_pattern}()},
\code{\link{seq_extract_pattern}()},
\code{\link{seq_remove_pattern}()},
\code{\link{seq_remove_position}()},
\code{\link{seq_replace_position}()},
\code{\link{seq_split_kmer}()},
\code{\link{seq_split_pattern}()}
}
\concept{string operations}
