\encoding{UTF-8}
\name{olito2015}
\alias{olito2015}
\docType{data}
\title{ A pollination network from the Canadian Rockies}
\description{
The total number of individuals collected on each plant species provide a rough estimate of the level of visitation that each species received.
}
\usage{data(olito2015)}

\details{
The authors studied the plant–pollinator assemblage in a large, contiguous low-alpine meadow on the east face of Mt Murray, located in the Canadian Rockies in Kananaskis Country, Alberta, during summer 2010. They sampled interactions between plants and pollinators in a square 1-ha plot located at 2350–2410 m elevation on every day that weather conditions were suitable for pollinator flight, from the day of first flowering, until killing frosts occurred and pollinators were no longer observed (24 June 2010 – 26 August 2010, a total of 32 sampling days). That is, they sampled on as many days as was biologically possible. The authors recorded plant–pollinator interactions along three 2 m x 100 m transects between the lower and upper plot boundaries. 

An interaction was recorded when an insect visitor was observed contacting floral reproductive structures. The authors documented interactions between 41 flowering plant species and 125 insect species, and constructed a quantitative plant–pollinator interaction matrix, with rows and columns corresponding to plant and pollinator species respectively, and cell values indicating the number of visits observed between corresponding plant and pollinator species. All network data, as well as a more detailed description of the study system and sampling methods are available as an online supplement (Supplementary material Appendix 1 – 2). Network data is also available from the Dryad Digital Repository \doi{10.5061/dryad.7st32}.

}

\references{
When using this data, please cite the original publication:

Olito C, Fox JW (2015) Species traits and abundances predict metrics of plant–pollinator network structure, but not pairwise interactions. Oikos 124(4): 428--436. \doi{10.1111/oik.01439}

Additionally, please cite the Dryad data package:

Olito C, Fox JW (2014) Data from: Species traits and abundances predict metrics of plant–pollinator network structure, but not pairwise interactions. Dryad Digital Repository. \doi{10.5061/dryad.7st32} 

}
\examples{
data(olito2015)
plotweb(olito2015)
}
\keyword{datasets}
