% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/List2DF.R
\name{List2DF}
\alias{List2DF}
\title{Convert bipartite-style list of matrices to dataframe}
\usage{
List2DF(List, PrimaryLab = "Primary", SecondaryLab = "Secondary",
  SiteNames = NULL)
}
\arguments{
\item{List}{An list of bipartite format matrices}

\item{PrimaryLab}{Label for the primary level of the bipartite web, e.g. 'Plants'}

\item{SecondaryLab}{Label for the secondary level of the bipartite web, e.g. 'Pollinators'}

\item{SiteNames}{Vector of names for the different sites (list elements). By default takes names of input matrices if they exist.}
}
\value{
A data.frame where the first column is the primary interactor, the second the secondary interactor and subsequent named columns detail the link strengths
}
\description{
List2DF returns a data frame in the format internally required for bipartiteD3 where the first
two columns list the interacting species, and subsequent columns list the link strengths in each site.
}
\details{
List2DF expects an list of multiple bipartite webs as may be created by the frame2webs(type.out='list') function in bipartite.
This structure includes row and column names to indicate the species, and a named third dimension giving
the names of each of the sites

Note a list of this format can be passed directly to bipartite_D3 since it will test for an list and apply List2DF() anyway.
}
\examples{

\dontrun{ testdata <- data.frame(higher = c("bee1","bee1","bee1","bee2","bee1","bee3"),
lower = c("plant1","plant2","plant1","plant2","plant3","plant4"),
webID = c("meadow","meadow","meadow","meadow","bog","bog"), freq=c(5,9,1,2,3,7))
bipartite::frame2webs(testdata, type.out = 'list')-> SmallTestWeb

List2DF(SmallTestWeb)
}
}
