% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.R
\name{legend.type}
\alias{legend.type}
\title{Legend type}
\usage{
legend.type(bp, samples = FALSE, means = FALSE, bags = FALSE, ellipses = FALSE,
new = FALSE, ...)
}
\arguments{
\item{bp}{an object of class \code{biplot}.}

\item{samples}{logical, indicating whether legend should be printed for samples, with default \code{FALSE}.}

\item{means}{logical, indicating whether legend should be printed for means, with default \code{FLASE}.}

\item{bags}{logical, indicating whether legend should be printed for bags, with default \code{FALSE}.}

\item{ellipses}{logical, indicating whether legend should be printed for concentration ellipses, with default \code{FALSE}.}

\item{new}{logical, indicating whether the legend should appear in a new window, with default \code{FALSE}.}

\item{...}{additional arguments to be sent to \code{legend()}.}
}
\value{
A list with the following components is available:
\item{samples}{TRUE or FALSE, whether legend for samples are provided.}
\item{means}{TRUE or FALSE, whether legend for class means are provided.}
\item{bags}{TRUE or FALSE, whether legend for alpha-bags are provided.}
\item{ellipses}{TRUE or FALSE, whether legend for kappa-ellipses are provided.}
\item{new}{TRUE or FALSE, whether legend appears on new plot.}
}
\description{
This function enables the user to format the legend and make a required selection to display.
}
\examples{
biplot (iris[,1:4], Title="Test biplot") |> PCA(group.aes = iris[,5]) |>
    legend.type(samples=TRUE) |> plot()
}
