% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouds.R
\name{density2D}
\alias{density2D}
\title{Create a density in 2-dimensions}
\usage{
density2D(
  bp,
  which = NULL,
  contours = F,
  h = NULL,
  n = 100,
  col = c("green", "yellow", "red"),
  contour.col = "black",
  cuts = 50,
  cex = 0.6,
  tcl = -0.2,
  mgp = c(0, -0.25, 0),
  layout.heights = c(100, 10),
  legend.mar = c(2, 5, 0, 5)
)
}
\arguments{
\item{bp}{object of class \code{biplot}}

\item{which}{which group.}

\item{contours}{logical indicating whether contours are added to the density plot}

\item{h}{vector of bandwidths for x and y directions, see \code{\link[MASS]{kde2d}}.}

\item{n}{number of grid points in each direction. Can be scalar or a length-2 integer
vector.}

\item{col}{vector of colours to use to form a 'continuous' sequence of colours.}

\item{contour.col}{colour of the contours.}

\item{cuts}{number of colours in \code{col}.}

\item{cex}{character expansion.}

\item{tcl}{The length of tick marks as a fraction of the height of a line of text.}

\item{mgp}{The margin line.}

\item{layout.heights}{A vector of values for the heights of rows.}

\item{legend.mar}{The margin line of the legend.}
}
\value{
An object of class \code{biplot}.
}
\description{
Create a density in 2-dimensions
}
\examples{
biplot(iris[,1:4],group.aes = iris[,5]) |> PCA() |> 
  density2D(which=3,col=c("white","purple","cyan","blue")) |> plot()
biplot(iris[,1:4],group.aes = iris[,5]) |> PCA() |> 
  density2D(which=3,col=c("white","purple","cyan","blue"),contours = TRUE,
  contour.col = "grey") |> plot()
}
