% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twilight.R
\name{twilight}
\alias{twilight}
\title{Get the nautical, civil, and solar dawn and dusk for a given timerange
and locations.}
\usage{
twilight(timeRange, latLon, crs_datum = "WGS84", timeZone)
}
\arguments{
\item{timeRange}{A two-element character vector with elements of the form
\%Y-\%m-\%d defining the start and end of the timerange for which you want to
get the twilight information.}

\item{latLon}{A list of X, Y coordinates}

\item{crs_datum}{The coordinate reference system and datum of the X, Y
coordinates. Default = "WGS84.}

\item{timeZone}{The time zone of the area of interest}
}
\value{
A data frame with the results
}
\description{
Get the time of nautical (sun at 12 degrees below horizon), civil
(sun at 6 degrees below horizon) and solar (sun at 0 degrees below horizon)
dawn and dusk for each day over a given time range.
}
\examples{
\dontrun{
sunrisesunset = twilight(timeRange = c("2021-01-15 00:00", 
                                       "2021-01-31 00:00"),
                         latLon    = c(47.494427, 8.716432),
                         timeZone  = "Etc/GMT0")
}
}
\author{
Fabian Hertner, \email{fabian.hertner@swiss-birdradar.com};
Birgen Haest, \email{birgen.haest@vogelwarte.ch}
}
