% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp.R
\name{.createObjBirp.birp}
\alias{.createObjBirp.birp}
\title{Function to create an object of type birp}
\usage{
.createObjBirp.birp(
  data,
  meanVar,
  trace,
  gamma,
  timepoints,
  timesOfChange,
  BACI,
  CI_groups,
  state
)
}
\arguments{
\item{data}{An object of type \link{birp_data}, corresponding to filtered data used for inference}

\item{meanVar}{A data frame containing the posterior mean and variance of all parameters}

\item{trace}{A data frame containing the MCMC trace of all parameters}

\item{gamma}{A data frame containing the posterior probabilities regarding gamma}

\item{timepoints}{An integer vector containing the timepoints at which counts were obtained}

\item{timesOfChange}{A numeric or integer vector specifying the times of change}

\item{BACI}{A matrix specifying the BACI configuration. Each row of the matrix corresponds to a control/intervention group, and each column to an epoch. The very first column specifies the name of the control-intervention group and must match the groups specified in data. The values of the matrix specify which gamma to use for each group and epoch. E.g. BACI = matrix(c("A", "B", 1, 1, 1, 2), nrow = 2) corresponds to a canonical BACI design where the first row represents the control group (A) and the second row represents the intervention group (B)}

\item{CI_groups}{A character vector specifying the names of the control-intervention (CI) group}

\item{state}{A data frame containing the posterior mean values of all parameters inferred by birp}
}
\value{
An object of type birp
}
\description{
Function to create an object of type birp
}
\keyword{internal}
