// Generated by rstantools.  Do not edit by hand.

/*
    bistablehistory is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bistablehistory is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bistablehistory.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_historylm_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 112, column 4 to column 31)",
                                                      " (in 'string', line 113, column 4 to column 46)",
                                                      " (in 'string', line 114, column 4 to column 33)",
                                                      " (in 'string', line 116, column 4 to column 47)",
                                                      " (in 'string', line 117, column 4 to column 62)",
                                                      " (in 'string', line 118, column 4 to column 49)",
                                                      " (in 'string', line 121, column 4 to column 33)",
                                                      " (in 'string', line 123, column 4 to column 22)",
                                                      " (in 'string', line 124, column 4 to column 56)",
                                                      " (in 'string', line 125, column 4 to column 74)",
                                                      " (in 'string', line 127, column 4 to column 54)",
                                                      " (in 'string', line 129, column 4 to column 37)",
                                                      " (in 'string', line 132, column 4 to column 39)",
                                                      " (in 'string', line 135, column 8 to column 27)",
                                                      " (in 'string', line 136, column 8 to column 34)",
                                                      " (in 'string', line 137, column 8 to column 17)",
                                                      " (in 'string', line 138, column 8 to column 16)",
                                                      " (in 'string', line 140, column 8 to column 19)",
                                                      " (in 'string', line 142, column 15 to column 22)",
                                                      " (in 'string', line 142, column 8 to column 137)",
                                                      " (in 'string', line 143, column 15 to column 22)",
                                                      " (in 'string', line 143, column 8 to column 187)",
                                                      " (in 'string', line 144, column 14 to column 17)",
                                                      " (in 'string', line 144, column 26 to column 33)",
                                                      " (in 'string', line 144, column 8 to column 42)",
                                                      " (in 'string', line 150, column 16 to column 71)",
                                                      " (in 'string', line 149, column 17 to line 151, column 13)",
                                                      " (in 'string', line 147, column 16 to column 62)",
                                                      " (in 'string', line 146, column 30 to line 148, column 13)",
                                                      " (in 'string', line 146, column 12 to line 151, column 13)",
                                                      " (in 'string', line 145, column 26 to line 152, column 9)",
                                                      " (in 'string', line 145, column 8 to line 152, column 9)",
                                                      " (in 'string', line 156, column 16 to column 69)",
                                                      " (in 'string', line 157, column 16 to column 63)",
                                                      " (in 'string', line 159, column 16 to line 160, column 63)",
                                                      " (in 'string', line 155, column 30 to line 161, column 13)",
                                                      " (in 'string', line 155, column 12 to line 161, column 13)",
                                                      " (in 'string', line 165, column 16 to column 81)",
                                                      " (in 'string', line 168, column 20 to column 92)",
                                                      " (in 'string', line 170, column 24 to column 71)",
                                                      " (in 'string', line 169, column 36 to line 171, column 21)",
                                                      " (in 'string', line 169, column 20 to line 171, column 21)",
                                                      " (in 'string', line 167, column 34 to line 172, column 17)",
                                                      " (in 'string', line 167, column 16 to line 172, column 17)",
                                                      " (in 'string', line 173, column 16 to column 24)",
                                                      " (in 'string', line 163, column 33 to line 174, column 13)",
                                                      " (in 'string', line 163, column 12 to line 174, column 13)",
                                                      " (in 'string', line 177, column 16 to column 151)",
                                                      " (in 'string', line 176, column 30 to line 178, column 13)",
                                                      " (in 'string', line 176, column 12 to line 178, column 13)",
                                                      " (in 'string', line 153, column 26 to line 179, column 9)",
                                                      " (in 'string', line 153, column 8 to line 179, column 9)",
                                                      " (in 'string', line 133, column 4 to line 180, column 5)",
                                                      " (in 'string', line 237, column 4 to column 27)",
                                                      " (in 'string', line 243, column 28 to column 102)",
                                                      " (in 'string', line 243, column 8 to column 102)",
                                                      " (in 'string', line 242, column 34 to line 244, column 5)",
                                                      " (in 'string', line 242, column 11 to line 244, column 5)",
                                                      " (in 'string', line 241, column 28 to column 110)",
                                                      " (in 'string', line 241, column 8 to column 110)",
                                                      " (in 'string', line 240, column 37 to line 242, column 5)",
                                                      " (in 'string', line 240, column 11 to line 244, column 5)",
                                                      " (in 'string', line 239, column 28 to column 122)",
                                                      " (in 'string', line 239, column 8 to column 122)",
                                                      " (in 'string', line 238, column 26 to line 240, column 5)",
                                                      " (in 'string', line 238, column 4 to line 244, column 5)",
                                                      " (in 'string', line 191, column 12 to column 56)",
                                                      " (in 'string', line 192, column 12 to column 40)",
                                                      " (in 'string', line 193, column 12 to column 35)",
                                                      " (in 'string', line 190, column 40 to line 194, column 9)",
                                                      " (in 'string', line 190, column 13 to line 194, column 9)",
                                                      " (in 'string', line 188, column 12 to column 57)",
                                                      " (in 'string', line 187, column 45 to line 189, column 9)",
                                                      " (in 'string', line 187, column 13 to line 194, column 9)",
                                                      " (in 'string', line 185, column 12 to column 56)",
                                                      " (in 'string', line 184, column 35 to line 186, column 9)",
                                                      " (in 'string', line 184, column 8 to line 194, column 9)",
                                                      " (in 'string', line 183, column 4 to line 195, column 5)",
                                                      " (in 'string', line 204, column 12 to column 80)",
                                                      " (in 'string', line 205, column 12 to column 48)",
                                                      " (in 'string', line 206, column 12 to column 43)",
                                                      " (in 'string', line 203, column 48 to line 207, column 9)",
                                                      " (in 'string', line 203, column 13 to line 207, column 9)",
                                                      " (in 'string', line 201, column 12 to column 81)",
                                                      " (in 'string', line 200, column 53 to line 202, column 9)",
                                                      " (in 'string', line 200, column 13 to line 207, column 9)",
                                                      " (in 'string', line 198, column 12 to column 80)",
                                                      " (in 'string', line 197, column 43 to line 199, column 9)",
                                                      " (in 'string', line 197, column 8 to line 207, column 9)",
                                                      " (in 'string', line 196, column 4 to line 208, column 5)",
                                                      " (in 'string', line 212, column 8 to column 58)",
                                                      " (in 'string', line 214, column 8 to column 64)",
                                                      " (in 'string', line 216, column 12 to column 43)",
                                                      " (in 'string', line 217, column 12 to column 39)",
                                                      " (in 'string', line 215, column 25 to line 218, column 9)",
                                                      " (in 'string', line 215, column 8 to line 218, column 9)",
                                                      " (in 'string', line 220, column 30 to column 93)",
                                                      " (in 'string', line 220, column 10 to column 93)",
                                                      " (in 'string', line 219, column 24 to line 221, column 9)",
                                                      " (in 'string', line 219, column 8 to line 221, column 9)",
                                                      " (in 'string', line 210, column 22 to line 222, column 5)",
                                                      " (in 'string', line 210, column 4 to line 222, column 5)",
                                                      " (in 'string', line 225, column 8 to column 31)",
                                                      " (in 'string', line 224, column 23 to line 226, column 5)",
                                                      " (in 'string', line 224, column 4 to line 226, column 5)",
                                                      " (in 'string', line 233, column 8 to column 55)",
                                                      " (in 'string', line 232, column 34 to line 234, column 5)",
                                                      " (in 'string', line 232, column 11 to line 234, column 5)",
                                                      " (in 'string', line 231, column 8 to column 63)",
                                                      " (in 'string', line 230, column 37 to line 232, column 5)",
                                                      " (in 'string', line 230, column 11 to line 234, column 5)",
                                                      " (in 'string', line 229, column 8 to column 72)",
                                                      " (in 'string', line 228, column 26 to line 230, column 5)",
                                                      " (in 'string', line 228, column 4 to line 234, column 5)",
                                                      " (in 'string', line 48, column 4 to column 33)",
                                                      " (in 'string', line 50, column 4 to column 23)",
                                                      " (in 'string', line 51, column 10 to column 15)",
                                                      " (in 'string', line 51, column 4 to column 31)",
                                                      " (in 'string', line 52, column 10 to column 15)",
                                                      " (in 'string', line 52, column 4 to column 28)",
                                                      " (in 'string', line 53, column 10 to column 15)",
                                                      " (in 'string', line 53, column 4 to column 29)",
                                                      " (in 'string', line 54, column 10 to column 15)",
                                                      " (in 'string', line 54, column 4 to column 31)",
                                                      " (in 'string', line 55, column 10 to column 15)",
                                                      " (in 'string', line 55, column 4 to column 36)",
                                                      " (in 'string', line 57, column 4 to column 15)",
                                                      " (in 'string', line 58, column 10 to column 16)",
                                                      " (in 'string', line 58, column 4 to column 38)",
                                                      " (in 'string', line 60, column 4 to column 25)",
                                                      " (in 'string', line 61, column 10 to column 15)",
                                                      " (in 'string', line 61, column 4 to column 53)",
                                                      " (in 'string', line 63, column 4 to column 24)",
                                                      " (in 'string', line 64, column 11 to column 16)",
                                                      " (in 'string', line 64, column 18 to column 41)",
                                                      " (in 'string', line 64, column 4 to column 49)",
                                                      " (in 'string', line 66, column 4 to column 60)",
                                                      " (in 'string', line 68, column 4 to column 37)",
                                                      " (in 'string', line 69, column 4 to column 28)",
                                                      " (in 'string', line 70, column 4 to column 20)",
                                                      " (in 'string', line 71, column 4 to column 23)",
                                                      " (in 'string', line 72, column 4 to column 21)",
                                                      " (in 'string', line 73, column 4 to column 28)",
                                                      " (in 'string', line 75, column 4 to column 45)",
                                                      " (in 'string', line 76, column 4 to column 45)",
                                                      " (in 'string', line 77, column 4 to column 28)",
                                                      " (in 'string', line 78, column 4 to column 31)",
                                                      " (in 'string', line 79, column 4 to column 29)",
                                                      " (in 'string', line 80, column 4 to column 36)",
                                                      " (in 'string', line 82, column 4 to column 21)",
                                                      " (in 'string', line 83, column 4 to column 36)",
                                                      " (in 'string', line 85, column 10 to column 13)",
                                                      " (in 'string', line 85, column 4 to column 31)",
                                                      " (in 'string', line 87, column 10 to column 13)",
                                                      " (in 'string', line 87, column 4 to column 32)",
                                                      " (in 'string', line 89, column 11 to column 34)",
                                                      " (in 'string', line 89, column 4 to column 52)",
                                                      " (in 'string', line 93, column 4 to column 19)",
                                                      " (in 'string', line 94, column 4 to column 23)",
                                                      " (in 'string', line 95, column 4 to column 20)",
                                                      " (in 'string', line 97, column 4 to column 22)",
                                                      " (in 'string', line 98, column 4 to column 20)",
                                                      " (in 'string', line 99, column 4 to column 25)",
                                                      " (in 'string', line 100, column 4 to column 20)",
                                                      " (in 'string', line 102, column 4 to column 20)",
                                                      " (in 'string', line 103, column 4 to column 20)",
                                                      " (in 'string', line 105, column 4 to column 23)",
                                                      " (in 'string', line 106, column 4 to column 18)",
                                                      " (in 'string', line 107, column 4 to column 20)",
                                                      " (in 'string', line 112, column 11 to column 22)",
                                                      " (in 'string', line 113, column 20 to column 34)",
                                                      " (in 'string', line 114, column 11 to column 23)",
                                                      " (in 'string', line 116, column 11 to column 30)",
                                                      " (in 'string', line 117, column 20 to column 42)",
                                                      " (in 'string', line 118, column 11 to column 31)",
                                                      " (in 'string', line 121, column 10 to column 13)",
                                                      " (in 'string', line 121, column 22 to column 29)",
                                                      " (in 'string', line 123, column 11 to column 14)",
                                                      " (in 'string', line 124, column 10 to column 31)",
                                                      " (in 'string', line 125, column 10 to column 31)",
                                                      " (in 'string', line 125, column 40 to column 65)",
                                                      " (in 'string', line 127, column 10 to column 30)",
                                                      " (in 'string', line 127, column 43 to column 49)",
                                                      " (in 'string', line 129, column 20 to column 29)",
                                                      " (in 'string', line 132, column 10 to column 13)",
                                                      " (in 'string', line 132, column 22 to column 28)",
                                                      " (in 'string', line 237, column 11 to column 17)",
                                                      " (in 'string', line 18, column 14 to column 21)",
                                                      " (in 'string', line 18, column 7 to column 27)",
                                                      " (in 'string', line 31, column 11 to column 40)",
                                                      " (in 'string', line 29, column 12 to line 32, column 8)",
                                                      " (in 'string', line 27, column 11 to column 21)",
                                                      " (in 'string', line 26, column 29 to line 28, column 8)",
                                                      " (in 'string', line 26, column 12 to line 32, column 8)",
                                                      " (in 'string', line 24, column 11 to column 44)",
                                                      " (in 'string', line 23, column 29 to line 25, column 8)",
                                                      " (in 'string', line 23, column 12 to line 32, column 8)",
                                                      " (in 'string', line 20, column 11 to column 50)",
                                                      " (in 'string', line 21, column 11 to column 22)",
                                                      " (in 'string', line 19, column 24 to line 22, column 8)",
                                                      " (in 'string', line 19, column 7 to line 32, column 8)",
                                                      " (in 'string', line 38, column 11 to column 33)",
                                                      " (in 'string', line 37, column 36 to line 39, column 8)",
                                                      " (in 'string', line 37, column 12 to line 39, column 8)",
                                                      " (in 'string', line 35, column 11 to column 27)",
                                                      " (in 'string', line 34, column 31 to line 36, column 8)",
                                                      " (in 'string', line 34, column 7 to line 39, column 8)",
                                                      " (in 'string', line 40, column 7 to column 19)",
                                                      " (in 'string', line 2, column 144 to line 41, column 4)"};
template <typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<stan::promote_args_t<T1__, stan::value_type_t<T2__>,
stan::value_type_t<T3__>,
stan::value_type_t<T4__>>, -1, 1>
expand_history_param_to_individuals(const int& option,
                                    const T1__& fixed_value,
                                    const T2__& mu_arg__,
                                    const T3__& sigma_arg__,
                                    const T4__& rnd_arg__,
                                    const int& randomN,
                                    const int& link_function,
                                    std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T1__,
          stan::value_type_t<T2__>,
          stan::value_type_t<T3__>,
          stan::value_type_t<T4__>>;
  const auto& mu = to_ref(mu_arg__);
  const auto& sigma = to_ref(sigma_arg__);
  const auto& rnd = to_ref(rnd_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 188;
    validate_non_negative_index("ind", "randomN", randomN);
    Eigen::Matrix<local_scalar_t__, -1, 1> ind;
    ind = Eigen::Matrix<local_scalar_t__, -1, 1>(randomN);
    stan::math::fill(ind, DUMMY_VAR__);
    
    current_statement__ = 201;
    if (logical_eq(option, 1)) {
      current_statement__ = 198;
      assign(ind, nil_index_list(), rep_vector(fixed_value, randomN),
        "assigning variable ind");
      current_statement__ = 199;
      return ind;
    } else {
      current_statement__ = 197;
      if (logical_eq(option, 2)) {
        current_statement__ = 195;
        assign(ind, nil_index_list(), rep_vector(mu[(1 - 1)], randomN),
          "assigning variable ind");
      } else {
        current_statement__ = 194;
        if (logical_eq(option, 3)) {
          current_statement__ = 192;
          assign(ind, nil_index_list(), rnd, "assigning variable ind");
        } else {
          current_statement__ = 190;
          assign(ind, nil_index_list(),
            add(mu[(1 - 1)], multiply(sigma[(1 - 1)], rnd)),
            "assigning variable ind");
        }
      }
    }
    current_statement__ = 207;
    if (logical_eq(link_function, 2)) {
      current_statement__ = 205;
      return stan::math::exp(ind);
    } else {
      current_statement__ = 204;
      if (logical_eq(link_function, 3)) {
        current_statement__ = 202;
        return inv_logit(ind);
      } 
    }
    current_statement__ = 208;
    return ind;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct expand_history_param_to_individuals_functor__ {
template <typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<stan::promote_args_t<T1__, stan::value_type_t<T2__>,
stan::value_type_t<T3__>,
stan::value_type_t<T4__>>, -1, 1>
operator()(const int& option, const T1__& fixed_value, const T2__& mu,
           const T3__& sigma, const T4__& rnd, const int& randomN,
           const int& link_function, std::ostream* pstream__)  const 
{
return expand_history_param_to_individuals(option, fixed_value, mu, sigma,
         rnd, randomN, link_function, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_historylm final : public model_base_crtp<model_historylm> {
private:
  int family;
  int rowsN;
  std::vector<double> duration;
  std::vector<int> istate;
  std::vector<int> is_used;
  std::vector<int> run_start;
  std::vector<double> session_tmean;
  int clearN;
  std::vector<double> clear_duration;
  int randomN;
  std::vector<int> irandom;
  int fixedN;
  Eigen::Matrix<double, -1, -1> fixed;
  std::vector<double> history_starting_values;
  int tau_option;
  double fixed_tau;
  int tau_mu_size;
  int tau_sigma_size;
  int tau_rnd_size;
  std::vector<double> tau_prior;
  int mixed_state_option;
  double fixed_mixed_state;
  int mixed_state_mu_size;
  int mixed_state_sigma_size;
  int mixed_state_rnd_size;
  std::vector<double> mixed_state_prior;
  int lmN;
  int varianceN;
  std::vector<std::vector<double>> a_prior;
  std::vector<std::vector<double>> bH_prior;
  Eigen::Matrix<double, -1, -1> fixed_priors;
  int lGamma;
  int lLogNormal;
  int lNormal;
  int oConstant;
  int oSingle;
  int oIndependent;
  int oPooled;
  int fSingle;
  int fPooled;
  int lfIdentity;
  int lfLog;
  int lfLogit;
  int bH_sigma_1dim__;
  int bH_rnd_1dim__;
  int bH_rnd_2dim__;
  int bF_1dim__;
 
public:
  ~model_historylm() { }
  
  inline std::string model_name() const final { return "model_historylm"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_historylm(stan::io::var_context& context__,
                  unsigned int random_seed__ = 0,
                  std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_historylm_namespace::model_historylm";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 115;
      context__.validate_dims("data initialization","family","int",
          context__.to_vec());
      family = std::numeric_limits<int>::min();
      
      current_statement__ = 115;
      family = context__.vals_i("family")[(1 - 1)];
      current_statement__ = 115;
      current_statement__ = 115;
      check_greater_or_equal(function__, "family", family, 1);
      current_statement__ = 115;
      current_statement__ = 115;
      check_less_or_equal(function__, "family", family, 3);
      current_statement__ = 116;
      context__.validate_dims("data initialization","rowsN","int",
          context__.to_vec());
      rowsN = std::numeric_limits<int>::min();
      
      current_statement__ = 116;
      rowsN = context__.vals_i("rowsN")[(1 - 1)];
      current_statement__ = 116;
      current_statement__ = 116;
      check_greater_or_equal(function__, "rowsN", rowsN, 1);
      current_statement__ = 117;
      validate_non_negative_index("duration", "rowsN", rowsN);
      current_statement__ = 118;
      context__.validate_dims("data initialization","duration","double",
          context__.to_vec(rowsN));
      duration = std::vector<double>(rowsN, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 118;
      assign(duration, nil_index_list(), context__.vals_r("duration"),
        "assigning variable duration");
      current_statement__ = 119;
      validate_non_negative_index("istate", "rowsN", rowsN);
      current_statement__ = 120;
      context__.validate_dims("data initialization","istate","int",
          context__.to_vec(rowsN));
      istate = std::vector<int>(rowsN, std::numeric_limits<int>::min());
      
      current_statement__ = 120;
      assign(istate, nil_index_list(), context__.vals_i("istate"),
        "assigning variable istate");
      current_statement__ = 121;
      validate_non_negative_index("is_used", "rowsN", rowsN);
      current_statement__ = 122;
      context__.validate_dims("data initialization","is_used","int",
          context__.to_vec(rowsN));
      is_used = std::vector<int>(rowsN, std::numeric_limits<int>::min());
      
      current_statement__ = 122;
      assign(is_used, nil_index_list(), context__.vals_i("is_used"),
        "assigning variable is_used");
      current_statement__ = 123;
      validate_non_negative_index("run_start", "rowsN", rowsN);
      current_statement__ = 124;
      context__.validate_dims("data initialization","run_start","int",
          context__.to_vec(rowsN));
      run_start = std::vector<int>(rowsN, std::numeric_limits<int>::min());
      
      current_statement__ = 124;
      assign(run_start, nil_index_list(), context__.vals_i("run_start"),
        "assigning variable run_start");
      current_statement__ = 125;
      validate_non_negative_index("session_tmean", "rowsN", rowsN);
      current_statement__ = 126;
      context__.validate_dims("data initialization","session_tmean","double",
          context__.to_vec(rowsN));
      session_tmean = std::vector<double>(rowsN, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 126;
      assign(session_tmean, nil_index_list(),
        context__.vals_r("session_tmean"), "assigning variable session_tmean");
      current_statement__ = 127;
      context__.validate_dims("data initialization","clearN","int",
          context__.to_vec());
      clearN = std::numeric_limits<int>::min();
      
      current_statement__ = 127;
      clearN = context__.vals_i("clearN")[(1 - 1)];
      current_statement__ = 128;
      validate_non_negative_index("clear_duration", "clearN", clearN);
      current_statement__ = 129;
      context__.validate_dims("data initialization","clear_duration",
          "double",context__.to_vec(clearN));
      clear_duration = std::vector<double>(clearN, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 129;
      assign(clear_duration, nil_index_list(),
        context__.vals_r("clear_duration"),
        "assigning variable clear_duration");
      current_statement__ = 130;
      context__.validate_dims("data initialization","randomN","int",
          context__.to_vec());
      randomN = std::numeric_limits<int>::min();
      
      current_statement__ = 130;
      randomN = context__.vals_i("randomN")[(1 - 1)];
      current_statement__ = 130;
      current_statement__ = 130;
      check_greater_or_equal(function__, "randomN", randomN, 1);
      current_statement__ = 131;
      validate_non_negative_index("irandom", "rowsN", rowsN);
      current_statement__ = 132;
      context__.validate_dims("data initialization","irandom","int",
          context__.to_vec(rowsN));
      irandom = std::vector<int>(rowsN, std::numeric_limits<int>::min());
      
      current_statement__ = 132;
      assign(irandom, nil_index_list(), context__.vals_i("irandom"),
        "assigning variable irandom");
      current_statement__ = 132;
      for (int sym1__ = 1; sym1__ <= rowsN; ++sym1__) {
        current_statement__ = 132;
        current_statement__ = 132;
        check_greater_or_equal(function__, "irandom[sym1__]",
                               irandom[(sym1__ - 1)], 1);}
      current_statement__ = 132;
      for (int sym1__ = 1; sym1__ <= rowsN; ++sym1__) {
        current_statement__ = 132;
        current_statement__ = 132;
        check_less_or_equal(function__, "irandom[sym1__]",
                            irandom[(sym1__ - 1)], randomN);}
      current_statement__ = 133;
      context__.validate_dims("data initialization","fixedN","int",
          context__.to_vec());
      fixedN = std::numeric_limits<int>::min();
      
      current_statement__ = 133;
      fixedN = context__.vals_i("fixedN")[(1 - 1)];
      current_statement__ = 133;
      current_statement__ = 133;
      check_greater_or_equal(function__, "fixedN", fixedN, 0);
      current_statement__ = 134;
      validate_non_negative_index("fixed", "rowsN", rowsN);
      current_statement__ = 135;
      validate_non_negative_index("fixed", "fixedN > 0 ? fixedN : 0",
                                  (logical_gt(fixedN, 0) ? fixedN : 0));
      current_statement__ = 136;
      context__.validate_dims("data initialization","fixed","double",
          context__.to_vec(rowsN, (logical_gt(fixedN, 0) ? fixedN : 0)));
      fixed = Eigen::Matrix<double, -1, -1>(rowsN, (logical_gt(fixedN, 0) ?
                                                      fixedN : 0));
      stan::math::fill(fixed, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> fixed_flat__;
        current_statement__ = 136;
        assign(fixed_flat__, nil_index_list(), context__.vals_r("fixed"),
          "assigning variable fixed_flat__");
        current_statement__ = 136;
        pos__ = 1;
        current_statement__ = 136;
        for (int sym1__ = 1; sym1__ <= (logical_gt(fixedN, 0) ? fixedN : 0);
             ++sym1__) {
          current_statement__ = 136;
          for (int sym2__ = 1; sym2__ <= rowsN; ++sym2__) {
            current_statement__ = 136;
            assign(fixed,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              fixed_flat__[(pos__ - 1)], "assigning variable fixed");
            current_statement__ = 136;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 137;
      context__.validate_dims("data initialization",
          "history_starting_values","double",context__.to_vec(2));
      history_starting_values = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 137;
      assign(history_starting_values, nil_index_list(),
        context__.vals_r("history_starting_values"),
        "assigning variable history_starting_values");
      current_statement__ = 137;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 137;
        current_statement__ = 137;
        check_greater_or_equal(function__, "history_starting_values[sym1__]",
                               history_starting_values[(sym1__ - 1)], 0);}
      current_statement__ = 137;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 137;
        current_statement__ = 137;
        check_less_or_equal(function__, "history_starting_values[sym1__]",
                            history_starting_values[(sym1__ - 1)], 1);}
      current_statement__ = 138;
      context__.validate_dims("data initialization","tau_option","int",
          context__.to_vec());
      tau_option = std::numeric_limits<int>::min();
      
      current_statement__ = 138;
      tau_option = context__.vals_i("tau_option")[(1 - 1)];
      current_statement__ = 138;
      current_statement__ = 138;
      check_greater_or_equal(function__, "tau_option", tau_option, 1);
      current_statement__ = 138;
      current_statement__ = 138;
      check_less_or_equal(function__, "tau_option", tau_option, 4);
      current_statement__ = 139;
      context__.validate_dims("data initialization","fixed_tau","double",
          context__.to_vec());
      fixed_tau = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 139;
      fixed_tau = context__.vals_r("fixed_tau")[(1 - 1)];
      current_statement__ = 139;
      current_statement__ = 139;
      check_greater_or_equal(function__, "fixed_tau", fixed_tau, 0);
      current_statement__ = 140;
      context__.validate_dims("data initialization","tau_mu_size","int",
          context__.to_vec());
      tau_mu_size = std::numeric_limits<int>::min();
      
      current_statement__ = 140;
      tau_mu_size = context__.vals_i("tau_mu_size")[(1 - 1)];
      current_statement__ = 141;
      context__.validate_dims("data initialization","tau_sigma_size","int",
          context__.to_vec());
      tau_sigma_size = std::numeric_limits<int>::min();
      
      current_statement__ = 141;
      tau_sigma_size = context__.vals_i("tau_sigma_size")[(1 - 1)];
      current_statement__ = 142;
      context__.validate_dims("data initialization","tau_rnd_size","int",
          context__.to_vec());
      tau_rnd_size = std::numeric_limits<int>::min();
      
      current_statement__ = 142;
      tau_rnd_size = context__.vals_i("tau_rnd_size")[(1 - 1)];
      current_statement__ = 143;
      context__.validate_dims("data initialization","tau_prior","double",
          context__.to_vec(2));
      tau_prior = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 143;
      assign(tau_prior, nil_index_list(), context__.vals_r("tau_prior"),
        "assigning variable tau_prior");
      current_statement__ = 144;
      context__.validate_dims("data initialization","mixed_state_option",
          "int",context__.to_vec());
      mixed_state_option = std::numeric_limits<int>::min();
      
      current_statement__ = 144;
      mixed_state_option = context__.vals_i("mixed_state_option")[(1 - 1)];
      current_statement__ = 144;
      current_statement__ = 144;
      check_greater_or_equal(function__, "mixed_state_option",
                             mixed_state_option, 1);
      current_statement__ = 144;
      current_statement__ = 144;
      check_less_or_equal(function__, "mixed_state_option",
                          mixed_state_option, 4);
      current_statement__ = 145;
      context__.validate_dims("data initialization","fixed_mixed_state",
          "double",context__.to_vec());
      fixed_mixed_state = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 145;
      fixed_mixed_state = context__.vals_r("fixed_mixed_state")[(1 - 1)];
      current_statement__ = 145;
      current_statement__ = 145;
      check_greater_or_equal(function__, "fixed_mixed_state",
                             fixed_mixed_state, 0);
      current_statement__ = 145;
      current_statement__ = 145;
      check_less_or_equal(function__, "fixed_mixed_state", fixed_mixed_state,
                          1);
      current_statement__ = 146;
      context__.validate_dims("data initialization","mixed_state_mu_size",
          "int",context__.to_vec());
      mixed_state_mu_size = std::numeric_limits<int>::min();
      
      current_statement__ = 146;
      mixed_state_mu_size = context__.vals_i("mixed_state_mu_size")[(1 - 1)];
      current_statement__ = 147;
      context__.validate_dims("data initialization","mixed_state_sigma_size",
          "int",context__.to_vec());
      mixed_state_sigma_size = std::numeric_limits<int>::min();
      
      current_statement__ = 147;
      mixed_state_sigma_size = context__.vals_i("mixed_state_sigma_size")[
          (1 - 1)];
      current_statement__ = 148;
      context__.validate_dims("data initialization","mixed_state_rnd_size",
          "int",context__.to_vec());
      mixed_state_rnd_size = std::numeric_limits<int>::min();
      
      current_statement__ = 148;
      mixed_state_rnd_size = context__.vals_i("mixed_state_rnd_size")[
          (1 - 1)];
      current_statement__ = 149;
      context__.validate_dims("data initialization","mixed_state_prior",
          "double",context__.to_vec(2));
      mixed_state_prior = std::vector<double>(2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 149;
      assign(mixed_state_prior, nil_index_list(),
        context__.vals_r("mixed_state_prior"),
        "assigning variable mixed_state_prior");
      current_statement__ = 150;
      context__.validate_dims("data initialization","lmN","int",
          context__.to_vec());
      lmN = std::numeric_limits<int>::min();
      
      current_statement__ = 150;
      lmN = context__.vals_i("lmN")[(1 - 1)];
      current_statement__ = 150;
      current_statement__ = 150;
      check_greater_or_equal(function__, "lmN", lmN, 1);
      current_statement__ = 151;
      context__.validate_dims("data initialization","varianceN","int",
          context__.to_vec());
      varianceN = std::numeric_limits<int>::min();
      
      current_statement__ = 151;
      varianceN = context__.vals_i("varianceN")[(1 - 1)];
      current_statement__ = 151;
      current_statement__ = 151;
      check_greater_or_equal(function__, "varianceN", varianceN, 0);
      current_statement__ = 151;
      current_statement__ = 151;
      check_less_or_equal(function__, "varianceN", varianceN, 1);
      current_statement__ = 152;
      validate_non_negative_index("a_prior", "lmN", lmN);
      current_statement__ = 153;
      context__.validate_dims("data initialization","a_prior","double",
          context__.to_vec(lmN, 2));
      a_prior = std::vector<std::vector<double>>(lmN, std::vector<double>(2, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> a_prior_flat__;
        current_statement__ = 153;
        assign(a_prior_flat__, nil_index_list(), context__.vals_r("a_prior"),
          "assigning variable a_prior_flat__");
        current_statement__ = 153;
        pos__ = 1;
        current_statement__ = 153;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 153;
          for (int sym2__ = 1; sym2__ <= lmN; ++sym2__) {
            current_statement__ = 153;
            assign(a_prior,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              a_prior_flat__[(pos__ - 1)], "assigning variable a_prior");
            current_statement__ = 153;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 154;
      validate_non_negative_index("bH_prior", "lmN", lmN);
      current_statement__ = 155;
      context__.validate_dims("data initialization","bH_prior","double",
          context__.to_vec(lmN, 2));
      bH_prior = std::vector<std::vector<double>>(lmN, std::vector<double>(2, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> bH_prior_flat__;
        current_statement__ = 155;
        assign(bH_prior_flat__, nil_index_list(),
          context__.vals_r("bH_prior"), "assigning variable bH_prior_flat__");
        current_statement__ = 155;
        pos__ = 1;
        current_statement__ = 155;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 155;
          for (int sym2__ = 1; sym2__ <= lmN; ++sym2__) {
            current_statement__ = 155;
            assign(bH_prior,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              bH_prior_flat__[(pos__ - 1)], "assigning variable bH_prior");
            current_statement__ = 155;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 156;
      validate_non_negative_index("fixed_priors", "fixedN > 0 ? fixedN : 0",
                                  (logical_gt(fixedN, 0) ? fixedN : 0));
      current_statement__ = 157;
      context__.validate_dims("data initialization","fixed_priors","double",
          context__.to_vec((logical_gt(fixedN, 0) ? fixedN : 0), 2));
      fixed_priors = Eigen::Matrix<double, -1, -1>((logical_gt(fixedN, 0) ?
                                                      fixedN : 0), 2);
      stan::math::fill(fixed_priors, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> fixed_priors_flat__;
        current_statement__ = 157;
        assign(fixed_priors_flat__, nil_index_list(),
          context__.vals_r("fixed_priors"),
          "assigning variable fixed_priors_flat__");
        current_statement__ = 157;
        pos__ = 1;
        current_statement__ = 157;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 157;
          for (int sym2__ = 1;
               sym2__ <= (logical_gt(fixedN, 0) ? fixedN : 0); ++sym2__) {
            current_statement__ = 157;
            assign(fixed_priors,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              fixed_priors_flat__[(pos__ - 1)],
              "assigning variable fixed_priors");
            current_statement__ = 157;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 158;
      lGamma = std::numeric_limits<int>::min();
      
      current_statement__ = 158;
      lGamma = 1;
      current_statement__ = 159;
      lLogNormal = std::numeric_limits<int>::min();
      
      current_statement__ = 159;
      lLogNormal = 2;
      current_statement__ = 160;
      lNormal = std::numeric_limits<int>::min();
      
      current_statement__ = 160;
      lNormal = 3;
      current_statement__ = 161;
      oConstant = std::numeric_limits<int>::min();
      
      current_statement__ = 161;
      oConstant = 1;
      current_statement__ = 162;
      oSingle = std::numeric_limits<int>::min();
      
      current_statement__ = 162;
      oSingle = 2;
      current_statement__ = 163;
      oIndependent = std::numeric_limits<int>::min();
      
      current_statement__ = 163;
      oIndependent = 3;
      current_statement__ = 164;
      oPooled = std::numeric_limits<int>::min();
      
      current_statement__ = 164;
      oPooled = 4;
      current_statement__ = 165;
      fSingle = std::numeric_limits<int>::min();
      
      current_statement__ = 165;
      fSingle = 1;
      current_statement__ = 166;
      fPooled = std::numeric_limits<int>::min();
      
      current_statement__ = 166;
      fPooled = 2;
      current_statement__ = 167;
      lfIdentity = std::numeric_limits<int>::min();
      
      current_statement__ = 167;
      lfIdentity = 1;
      current_statement__ = 168;
      lfLog = std::numeric_limits<int>::min();
      
      current_statement__ = 168;
      lfLog = 2;
      current_statement__ = 169;
      lfLogit = std::numeric_limits<int>::min();
      
      current_statement__ = 169;
      lfLogit = 3;
      current_statement__ = 170;
      validate_non_negative_index("tau_mu", "tau_mu_size", tau_mu_size);
      current_statement__ = 171;
      validate_non_negative_index("tau_sigma", "tau_sigma_size",
                                  tau_sigma_size);
      current_statement__ = 172;
      validate_non_negative_index("tau_rnd", "tau_rnd_size", tau_rnd_size);
      current_statement__ = 173;
      validate_non_negative_index("mixed_state_mu", "mixed_state_mu_size",
                                  mixed_state_mu_size);
      current_statement__ = 174;
      validate_non_negative_index("mixed_state_sigma",
                                  "mixed_state_sigma_size",
                                  mixed_state_sigma_size);
      current_statement__ = 175;
      validate_non_negative_index("mixed_state_rnd", "mixed_state_rnd_size",
                                  mixed_state_rnd_size);
      current_statement__ = 176;
      validate_non_negative_index("a", "lmN", lmN);
      current_statement__ = 177;
      validate_non_negative_index("a", "randomN", randomN);
      current_statement__ = 178;
      validate_non_negative_index("bH_mu", "lmN", lmN);
      current_statement__ = 179;
      bH_sigma_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 179;
      bH_sigma_1dim__ = (logical_gt(randomN, 1) ? lmN : 0);
      current_statement__ = 179;
      validate_non_negative_index("bH_sigma", "randomN > 1 ? lmN : 0",
                                  bH_sigma_1dim__);
      current_statement__ = 180;
      bH_rnd_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 180;
      bH_rnd_1dim__ = (logical_gt(randomN, 1) ? lmN : 0);
      current_statement__ = 180;
      validate_non_negative_index("bH_rnd", "randomN > 1 ? lmN : 0",
                                  bH_rnd_1dim__);
      current_statement__ = 181;
      bH_rnd_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 181;
      bH_rnd_2dim__ = (logical_gt(randomN, 1) ? randomN : 0);
      current_statement__ = 181;
      validate_non_negative_index("bH_rnd", "randomN > 1 ? randomN : 0",
                                  bH_rnd_2dim__);
      current_statement__ = 182;
      bF_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 182;
      bF_1dim__ = (logical_gt(fixedN, 0) ? lmN : 0);
      current_statement__ = 182;
      validate_non_negative_index("bF", "fixedN > 0 ? lmN : 0", bF_1dim__);
      current_statement__ = 183;
      validate_non_negative_index("bF", "fixedN", fixedN);
      current_statement__ = 184;
      validate_non_negative_index("sigma", "varianceN", varianceN);
      current_statement__ = 185;
      validate_non_negative_index("lm_param", "lmN", lmN);
      current_statement__ = 186;
      validate_non_negative_index("lm_param", "clearN", clearN);
      current_statement__ = 187;
      validate_non_negative_index("log_lik", "clearN", clearN);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += tau_mu_size;
      num_params_r__ += tau_sigma_size;
      num_params_r__ += tau_rnd_size;
      num_params_r__ += mixed_state_mu_size;
      num_params_r__ += mixed_state_sigma_size;
      num_params_r__ += mixed_state_rnd_size;
      num_params_r__ += lmN * randomN;
      num_params_r__ += lmN;
      num_params_r__ += bH_sigma_1dim__;
      num_params_r__ += bH_rnd_1dim__ * bH_rnd_2dim__;
      num_params_r__ += bF_1dim__ * fixedN;
      num_params_r__ += varianceN;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_historylm_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> tau_mu;
      tau_mu = Eigen::Matrix<local_scalar_t__, -1, 1>(tau_mu_size);
      stan::math::fill(tau_mu, DUMMY_VAR__);
      
      current_statement__ = 1;
      tau_mu = in__.vector(tau_mu_size);
      Eigen::Matrix<local_scalar_t__, -1, 1> tau_sigma;
      tau_sigma = Eigen::Matrix<local_scalar_t__, -1, 1>(tau_sigma_size);
      stan::math::fill(tau_sigma, DUMMY_VAR__);
      
      current_statement__ = 2;
      tau_sigma = in__.vector(tau_sigma_size);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= tau_sigma_size; ++sym1__) {
        current_statement__ = 2;
        if (jacobian__) {
          current_statement__ = 2;
          assign(tau_sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(tau_sigma[(sym1__ - 1)], 0, lp__),
            "assigning variable tau_sigma");
        } else {
          current_statement__ = 2;
          assign(tau_sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(tau_sigma[(sym1__ - 1)], 0),
            "assigning variable tau_sigma");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> tau_rnd;
      tau_rnd = Eigen::Matrix<local_scalar_t__, -1, 1>(tau_rnd_size);
      stan::math::fill(tau_rnd, DUMMY_VAR__);
      
      current_statement__ = 3;
      tau_rnd = in__.vector(tau_rnd_size);
      Eigen::Matrix<local_scalar_t__, -1, 1> mixed_state_mu;
      mixed_state_mu = Eigen::Matrix<local_scalar_t__, -1, 1>(mixed_state_mu_size);
      stan::math::fill(mixed_state_mu, DUMMY_VAR__);
      
      current_statement__ = 4;
      mixed_state_mu = in__.vector(mixed_state_mu_size);
      Eigen::Matrix<local_scalar_t__, -1, 1> mixed_state_sigma;
      mixed_state_sigma = Eigen::Matrix<local_scalar_t__, -1, 1>(mixed_state_sigma_size);
      stan::math::fill(mixed_state_sigma, DUMMY_VAR__);
      
      current_statement__ = 5;
      mixed_state_sigma = in__.vector(mixed_state_sigma_size);
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= mixed_state_sigma_size; ++sym1__) {
        current_statement__ = 5;
        if (jacobian__) {
          current_statement__ = 5;
          assign(mixed_state_sigma,
            cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(mixed_state_sigma[(sym1__ - 1)], 0, lp__),
            "assigning variable mixed_state_sigma");
        } else {
          current_statement__ = 5;
          assign(mixed_state_sigma,
            cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(mixed_state_sigma[(sym1__ - 1)], 0),
            "assigning variable mixed_state_sigma");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> mixed_state_rnd;
      mixed_state_rnd = Eigen::Matrix<local_scalar_t__, -1, 1>(mixed_state_rnd_size);
      stan::math::fill(mixed_state_rnd, DUMMY_VAR__);
      
      current_statement__ = 6;
      mixed_state_rnd = in__.vector(mixed_state_rnd_size);
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> a;
      a = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(lmN, Eigen::Matrix<local_scalar_t__, -1, 1>(randomN));
      stan::math::fill(a, DUMMY_VAR__);
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= lmN; ++sym1__) {
        current_statement__ = 7;
        assign(a, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(randomN), "assigning variable a");}
      Eigen::Matrix<local_scalar_t__, -1, 1> bH_mu;
      bH_mu = Eigen::Matrix<local_scalar_t__, -1, 1>(lmN);
      stan::math::fill(bH_mu, DUMMY_VAR__);
      
      current_statement__ = 8;
      bH_mu = in__.vector(lmN);
      std::vector<local_scalar_t__> bH_sigma;
      bH_sigma = std::vector<local_scalar_t__>(bH_sigma_1dim__, DUMMY_VAR__);
      
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= bH_sigma_1dim__; ++sym1__) {
        current_statement__ = 9;
        assign(bH_sigma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable bH_sigma");}
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= bH_sigma_1dim__; ++sym1__) {
        current_statement__ = 9;
        if (jacobian__) {
          current_statement__ = 9;
          assign(bH_sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(bH_sigma[(sym1__ - 1)], 0, lp__),
            "assigning variable bH_sigma");
        } else {
          current_statement__ = 9;
          assign(bH_sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(bH_sigma[(sym1__ - 1)], 0),
            "assigning variable bH_sigma");
        }}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> bH_rnd;
      bH_rnd = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(bH_rnd_1dim__, Eigen::Matrix<local_scalar_t__, -1, 1>(bH_rnd_2dim__));
      stan::math::fill(bH_rnd, DUMMY_VAR__);
      
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= bH_rnd_1dim__; ++sym1__) {
        current_statement__ = 10;
        assign(bH_rnd, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(bH_rnd_2dim__), "assigning variable bH_rnd");}
      std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>> bF;
      bF = std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>(bF_1dim__, Eigen::Matrix<local_scalar_t__, 1, -1>(fixedN));
      stan::math::fill(bF, DUMMY_VAR__);
      
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= bF_1dim__; ++sym1__) {
        current_statement__ = 11;
        assign(bF, cons_list(index_uni(sym1__), nil_index_list()),
          in__.row_vector(fixedN), "assigning variable bF");}
      Eigen::Matrix<local_scalar_t__, -1, 1> sigma;
      sigma = Eigen::Matrix<local_scalar_t__, -1, 1>(varianceN);
      stan::math::fill(sigma, DUMMY_VAR__);
      
      current_statement__ = 12;
      sigma = in__.vector(varianceN);
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= varianceN; ++sym1__) {
        current_statement__ = 12;
        if (jacobian__) {
          current_statement__ = 12;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma");
        } else {
          current_statement__ = 12;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma[(sym1__ - 1)], 0),
            "assigning variable sigma");
        }}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> lm_param;
      lm_param = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(lmN, Eigen::Matrix<local_scalar_t__, -1, 1>(clearN));
      stan::math::fill(lm_param, DUMMY_VAR__);
      
      {
        Eigen::Matrix<local_scalar_t__, -1, -1> level;
        level = Eigen::Matrix<local_scalar_t__, -1, -1>(2, 3);
        stan::math::fill(level, DUMMY_VAR__);
        
        Eigen::Matrix<local_scalar_t__, -1, 1> current_history;
        current_history = Eigen::Matrix<local_scalar_t__, -1, 1>(2);
        stan::math::fill(current_history, DUMMY_VAR__);
        
        local_scalar_t__ tau;
        tau = DUMMY_VAR__;
        
        local_scalar_t__ dH;
        dH = DUMMY_VAR__;
        
        int iC;
        iC = std::numeric_limits<int>::min();
        
        current_statement__ = 18;
        iC = 1;
        current_statement__ = 19;
        validate_non_negative_index("tau_ind", "randomN", randomN);
        Eigen::Matrix<local_scalar_t__, -1, 1> tau_ind;
        tau_ind = Eigen::Matrix<local_scalar_t__, -1, 1>(randomN);
        stan::math::fill(tau_ind, DUMMY_VAR__);
        
        current_statement__ = 20;
        assign(tau_ind, nil_index_list(),
          expand_history_param_to_individuals(tau_option, fixed_tau, tau_mu,
            tau_sigma, tau_rnd, randomN, lfLog, pstream__),
          "assigning variable tau_ind");
        current_statement__ = 21;
        validate_non_negative_index("mixed_state_ind", "randomN", randomN);
        Eigen::Matrix<local_scalar_t__, -1, 1> mixed_state_ind;
        mixed_state_ind = Eigen::Matrix<local_scalar_t__, -1, 1>(randomN);
        stan::math::fill(mixed_state_ind, DUMMY_VAR__);
        
        current_statement__ = 22;
        assign(mixed_state_ind, nil_index_list(),
          expand_history_param_to_individuals(mixed_state_option,
            fixed_mixed_state, mixed_state_mu, mixed_state_sigma,
            mixed_state_rnd, randomN, lfLogit, pstream__),
          "assigning variable mixed_state_ind");
        current_statement__ = 23;
        validate_non_negative_index("bH_ind", "lmN", lmN);
        current_statement__ = 24;
        validate_non_negative_index("bH_ind", "randomN", randomN);
        std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> bH_ind;
        bH_ind = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(lmN, Eigen::Matrix<local_scalar_t__, -1, 1>(randomN));
        stan::math::fill(bH_ind, DUMMY_VAR__);
        
        current_statement__ = 32;
        for (int iLM = 1; iLM <= lmN; ++iLM) {
          current_statement__ = 30;
          if (logical_eq(randomN, 1)) {
            current_statement__ = 28;
            assign(bH_ind, cons_list(index_uni(iLM), nil_index_list()),
              rep_vector(bH_mu[(iLM - 1)], randomN),
              "assigning variable bH_ind");
          } else {
            current_statement__ = 26;
            assign(bH_ind, cons_list(index_uni(iLM), nil_index_list()),
              add(bH_mu[(iLM - 1)],
                multiply(bH_sigma[(iLM - 1)], bH_rnd[(iLM - 1)])),
              "assigning variable bH_ind");
          }}
        current_statement__ = 52;
        for (int iT = 1; iT <= rowsN; ++iT) {
          current_statement__ = 37;
          if (run_start[(iT - 1)]) {
            current_statement__ = 33;
            assign(current_history, nil_index_list(),
              to_vector(history_starting_values),
              "assigning variable current_history");
            current_statement__ = 34;
            tau = (session_tmean[(iT - 1)] *
                    tau_ind[(irandom[(iT - 1)] - 1)]);
            current_statement__ = 35;
            assign(level, nil_index_list(), stan::math::to_matrix(
              std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
              (Eigen::Matrix<local_scalar_t__,1,-1>(3) << 1, 0,
              mixed_state_ind[(irandom[(iT - 1)] - 1)]).finished(),
              (Eigen::Matrix<local_scalar_t__,1,-1>(3) << 0, 1,
              mixed_state_ind[(irandom[(iT - 1)] - 1)]).finished()}),
              "assigning variable level");
          } 
          current_statement__ = 47;
          if (logical_eq(is_used[(iT - 1)], 1)) {
            current_statement__ = 38;
            dH = (current_history[((3 - istate[(iT - 1)]) - 1)] -
                   current_history[(istate[(iT - 1)] - 1)]);
            current_statement__ = 44;
            for (int iLM = 1; iLM <= lmN; ++iLM) {
              current_statement__ = 39;
              assign(lm_param,
                cons_list(index_uni(iLM),
                  cons_list(index_uni(iC), nil_index_list())),
                (a[(iLM - 1)][(irandom[(iT - 1)] - 1)] +
                  (bH_ind[(iLM - 1)][(irandom[(iT - 1)] - 1)] * dH)),
                "assigning variable lm_param");
              current_statement__ = 42;
              if (logical_gt(fixedN, 0)) {
                current_statement__ = 40;
                assign(lm_param,
                  cons_list(index_uni(iLM),
                    cons_list(index_uni(iC), nil_index_list())),
                  (lm_param[(iLM - 1)][(iC - 1)] +
                    sum(
                      elt_multiply(bF[(iLM - 1)],
                        rvalue(fixed,
                          cons_list(index_uni(iT), nil_index_list()),
                          "fixed")))), "assigning variable lm_param");
              } }
            current_statement__ = 45;
            iC = (iC + 1);
          } 
          current_statement__ = 50;
          for (int iState = 1; iState <= 2; ++iState) {
            current_statement__ = 48;
            assign(current_history,
              cons_list(index_uni(iState), nil_index_list()),
              (rvalue(level,
                 cons_list(index_uni(iState),
                   cons_list(index_uni(istate[(iT - 1)]), nil_index_list())),
                 "level") +
                ((current_history[(iState - 1)] -
                   rvalue(level,
                     cons_list(index_uni(iState),
                       cons_list(index_uni(istate[(iT - 1)]),
                         nil_index_list())), "level")) *
                  stan::math::exp((-duration[(iT - 1)] / tau)))),
              "assigning variable current_history");}}
      }
      {
        {
          current_statement__ = 77;
          if (logical_eq(tau_option, oSingle)) {
            current_statement__ = 75;
            lp_accum__.add(
              normal_lpdf<propto__>(tau_mu, tau_prior[(1 - 1)],
                tau_prior[(2 - 1)]));
          } else {
            current_statement__ = 74;
            if (logical_eq(tau_option, oIndependent)) {
              current_statement__ = 72;
              lp_accum__.add(
                normal_lpdf<propto__>(tau_rnd, tau_prior[(1 - 1)],
                  tau_prior[(2 - 1)]));
            } else {
              current_statement__ = 71;
              if (logical_eq(tau_option, oPooled)) {
                current_statement__ = 67;
                lp_accum__.add(
                  normal_lpdf<propto__>(tau_mu, tau_prior[(1 - 1)],
                    tau_prior[(2 - 1)]));
                current_statement__ = 68;
                lp_accum__.add(exponential_lpdf<propto__>(tau_sigma, 10));
                current_statement__ = 69;
                lp_accum__.add(normal_lpdf<propto__>(tau_rnd, 0, 1));
              } 
            }
          }
        }
        {
          current_statement__ = 89;
          if (logical_eq(mixed_state_option, oSingle)) {
            current_statement__ = 87;
            lp_accum__.add(
              normal_lpdf<propto__>(mixed_state_mu,
                mixed_state_prior[(1 - 1)], mixed_state_prior[(2 - 1)]));
          } else {
            current_statement__ = 86;
            if (logical_eq(mixed_state_option, oIndependent)) {
              current_statement__ = 84;
              lp_accum__.add(
                normal_lpdf<propto__>(mixed_state_rnd,
                  mixed_state_prior[(1 - 1)], mixed_state_prior[(2 - 1)]));
            } else {
              current_statement__ = 83;
              if (logical_eq(mixed_state_option, oPooled)) {
                current_statement__ = 79;
                lp_accum__.add(
                  normal_lpdf<propto__>(mixed_state_mu,
                    mixed_state_prior[(1 - 1)], mixed_state_prior[(2 - 1)]));
                current_statement__ = 80;
                lp_accum__.add(
                  exponential_lpdf<propto__>(mixed_state_sigma, 10));
                current_statement__ = 81;
                lp_accum__.add(normal_lpdf<propto__>(mixed_state_rnd, 0, 1));
              } 
            }
          }
        }
        current_statement__ = 102;
        for (int iLM = 1; iLM <= lmN; ++iLM) {
          current_statement__ = 91;
          lp_accum__.add(
            normal_lpdf<propto__>(a[(iLM - 1)], a_prior[(iLM - 1)][(1 - 1)],
              a_prior[(iLM - 1)][(2 - 1)]));
          current_statement__ = 92;
          lp_accum__.add(
            normal_lpdf<propto__>(bH_mu[(iLM - 1)],
              bH_prior[(iLM - 1)][(1 - 1)], bH_prior[(iLM - 1)][(2 - 1)]));
          current_statement__ = 96;
          if (logical_gt(randomN, 1)) {
            current_statement__ = 93;
            lp_accum__.add(exponential_lpdf<propto__>(bH_sigma[(iLM - 1)], 1));
            current_statement__ = 94;
            lp_accum__.add(normal_lpdf<propto__>(bH_rnd[(iLM - 1)], 0, 1));
          } 
          current_statement__ = 100;
          if (logical_gt(fixedN, 0)) {
            current_statement__ = 98;
            for (int iF = 1; iF <= fixedN; ++iF) {
              current_statement__ = 97;
              lp_accum__.add(
                normal_lpdf<propto__>(bF[(iLM - 1)][(iF - 1)],
                  rvalue(fixed_priors,
                    cons_list(index_uni(iF),
                      cons_list(index_uni(1), nil_index_list())),
                    "fixed_priors"),
                  rvalue(fixed_priors,
                    cons_list(index_uni(iF),
                      cons_list(index_uni(2), nil_index_list())),
                    "fixed_priors")));}
          } }
        current_statement__ = 105;
        if (logical_gt(varianceN, 0)) {
          current_statement__ = 103;
          lp_accum__.add(exponential_lpdf<propto__>(sigma, 1));
        } 
        current_statement__ = 114;
        if (logical_eq(family, lGamma)) {
          current_statement__ = 112;
          lp_accum__.add(
            gamma_lpdf<propto__>(clear_duration,
              stan::math::exp(lm_param[(1 - 1)]),
              elt_divide(1, stan::math::exp(lm_param[(2 - 1)]))));
        } else {
          current_statement__ = 111;
          if (logical_eq(family, lLogNormal)) {
            current_statement__ = 109;
            lp_accum__.add(
              lognormal_lpdf<propto__>(clear_duration,
                stan::math::exp(lm_param[(1 - 1)]), sigma[(1 - 1)]));
          } else {
            current_statement__ = 108;
            if (logical_eq(family, lNormal)) {
              current_statement__ = 106;
              lp_accum__.add(
                normal_lpdf<propto__>(clear_duration, lm_param[(1 - 1)],
                  sigma[(1 - 1)]));
            } 
          }
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_historylm_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> tau_mu;
      tau_mu = Eigen::Matrix<double, -1, 1>(tau_mu_size);
      stan::math::fill(tau_mu, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      tau_mu = in__.vector(tau_mu_size);
      Eigen::Matrix<double, -1, 1> tau_sigma;
      tau_sigma = Eigen::Matrix<double, -1, 1>(tau_sigma_size);
      stan::math::fill(tau_sigma, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      tau_sigma = in__.vector(tau_sigma_size);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= tau_sigma_size; ++sym1__) {
        current_statement__ = 2;
        assign(tau_sigma, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(tau_sigma[(sym1__ - 1)], 0),
          "assigning variable tau_sigma");}
      Eigen::Matrix<double, -1, 1> tau_rnd;
      tau_rnd = Eigen::Matrix<double, -1, 1>(tau_rnd_size);
      stan::math::fill(tau_rnd, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      tau_rnd = in__.vector(tau_rnd_size);
      Eigen::Matrix<double, -1, 1> mixed_state_mu;
      mixed_state_mu = Eigen::Matrix<double, -1, 1>(mixed_state_mu_size);
      stan::math::fill(mixed_state_mu, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      mixed_state_mu = in__.vector(mixed_state_mu_size);
      Eigen::Matrix<double, -1, 1> mixed_state_sigma;
      mixed_state_sigma = Eigen::Matrix<double, -1, 1>(mixed_state_sigma_size);
      stan::math::fill(mixed_state_sigma, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      mixed_state_sigma = in__.vector(mixed_state_sigma_size);
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= mixed_state_sigma_size; ++sym1__) {
        current_statement__ = 5;
        assign(mixed_state_sigma,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(mixed_state_sigma[(sym1__ - 1)], 0),
          "assigning variable mixed_state_sigma");}
      Eigen::Matrix<double, -1, 1> mixed_state_rnd;
      mixed_state_rnd = Eigen::Matrix<double, -1, 1>(mixed_state_rnd_size);
      stan::math::fill(mixed_state_rnd, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      mixed_state_rnd = in__.vector(mixed_state_rnd_size);
      std::vector<Eigen::Matrix<double, -1, 1>> a;
      a = std::vector<Eigen::Matrix<double, -1, 1>>(lmN, Eigen::Matrix<double, -1, 1>(randomN));
      stan::math::fill(a, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= lmN; ++sym1__) {
        current_statement__ = 7;
        assign(a, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(randomN), "assigning variable a");}
      Eigen::Matrix<double, -1, 1> bH_mu;
      bH_mu = Eigen::Matrix<double, -1, 1>(lmN);
      stan::math::fill(bH_mu, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      bH_mu = in__.vector(lmN);
      std::vector<double> bH_sigma;
      bH_sigma = std::vector<double>(bH_sigma_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= bH_sigma_1dim__; ++sym1__) {
        current_statement__ = 9;
        assign(bH_sigma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable bH_sigma");}
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= bH_sigma_1dim__; ++sym1__) {
        current_statement__ = 9;
        assign(bH_sigma, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(bH_sigma[(sym1__ - 1)], 0),
          "assigning variable bH_sigma");}
      std::vector<Eigen::Matrix<double, -1, 1>> bH_rnd;
      bH_rnd = std::vector<Eigen::Matrix<double, -1, 1>>(bH_rnd_1dim__, Eigen::Matrix<double, -1, 1>(bH_rnd_2dim__));
      stan::math::fill(bH_rnd, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= bH_rnd_1dim__; ++sym1__) {
        current_statement__ = 10;
        assign(bH_rnd, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(bH_rnd_2dim__), "assigning variable bH_rnd");}
      std::vector<Eigen::Matrix<double, 1, -1>> bF;
      bF = std::vector<Eigen::Matrix<double, 1, -1>>(bF_1dim__, Eigen::Matrix<double, 1, -1>(fixedN));
      stan::math::fill(bF, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= bF_1dim__; ++sym1__) {
        current_statement__ = 11;
        assign(bF, cons_list(index_uni(sym1__), nil_index_list()),
          in__.row_vector(fixedN), "assigning variable bF");}
      Eigen::Matrix<double, -1, 1> sigma;
      sigma = Eigen::Matrix<double, -1, 1>(varianceN);
      stan::math::fill(sigma, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 12;
      sigma = in__.vector(varianceN);
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= varianceN; ++sym1__) {
        current_statement__ = 12;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma[(sym1__ - 1)], 0),
          "assigning variable sigma");}
      std::vector<Eigen::Matrix<double, -1, 1>> lm_param;
      lm_param = std::vector<Eigen::Matrix<double, -1, 1>>(lmN, Eigen::Matrix<double, -1, 1>(clearN));
      stan::math::fill(lm_param, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= tau_mu_size; ++sym1__) {
        vars__.emplace_back(tau_mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= tau_sigma_size; ++sym1__) {
        vars__.emplace_back(tau_sigma[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= tau_rnd_size; ++sym1__) {
        vars__.emplace_back(tau_rnd[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= mixed_state_mu_size; ++sym1__) {
        vars__.emplace_back(mixed_state_mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= mixed_state_sigma_size; ++sym1__) {
        vars__.emplace_back(mixed_state_sigma[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= mixed_state_rnd_size; ++sym1__) {
        vars__.emplace_back(mixed_state_rnd[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= randomN; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= lmN; ++sym2__) {
          vars__.emplace_back(a[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= lmN; ++sym1__) {
        vars__.emplace_back(bH_mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= bH_sigma_1dim__; ++sym1__) {
        vars__.emplace_back(bH_sigma[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= bH_rnd_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= bH_rnd_1dim__; ++sym2__) {
          vars__.emplace_back(bH_rnd[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= fixedN; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= bF_1dim__; ++sym2__) {
          vars__.emplace_back(bF[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= varianceN; ++sym1__) {
        vars__.emplace_back(sigma[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      {
        Eigen::Matrix<double, -1, -1> level;
        level = Eigen::Matrix<double, -1, -1>(2, 3);
        stan::math::fill(level, std::numeric_limits<double>::quiet_NaN());
        
        Eigen::Matrix<double, -1, 1> current_history;
        current_history = Eigen::Matrix<double, -1, 1>(2);
        stan::math::fill(current_history, std::numeric_limits<double>::quiet_NaN());
        
        double tau;
        tau = std::numeric_limits<double>::quiet_NaN();
        
        double dH;
        dH = std::numeric_limits<double>::quiet_NaN();
        
        int iC;
        iC = std::numeric_limits<int>::min();
        
        current_statement__ = 18;
        iC = 1;
        current_statement__ = 19;
        validate_non_negative_index("tau_ind", "randomN", randomN);
        Eigen::Matrix<double, -1, 1> tau_ind;
        tau_ind = Eigen::Matrix<double, -1, 1>(randomN);
        stan::math::fill(tau_ind, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 20;
        assign(tau_ind, nil_index_list(),
          expand_history_param_to_individuals(tau_option, fixed_tau, tau_mu,
            tau_sigma, tau_rnd, randomN, lfLog, pstream__),
          "assigning variable tau_ind");
        current_statement__ = 21;
        validate_non_negative_index("mixed_state_ind", "randomN", randomN);
        Eigen::Matrix<double, -1, 1> mixed_state_ind;
        mixed_state_ind = Eigen::Matrix<double, -1, 1>(randomN);
        stan::math::fill(mixed_state_ind, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 22;
        assign(mixed_state_ind, nil_index_list(),
          expand_history_param_to_individuals(mixed_state_option,
            fixed_mixed_state, mixed_state_mu, mixed_state_sigma,
            mixed_state_rnd, randomN, lfLogit, pstream__),
          "assigning variable mixed_state_ind");
        current_statement__ = 23;
        validate_non_negative_index("bH_ind", "lmN", lmN);
        current_statement__ = 24;
        validate_non_negative_index("bH_ind", "randomN", randomN);
        std::vector<Eigen::Matrix<double, -1, 1>> bH_ind;
        bH_ind = std::vector<Eigen::Matrix<double, -1, 1>>(lmN, Eigen::Matrix<double, -1, 1>(randomN));
        stan::math::fill(bH_ind, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 32;
        for (int iLM = 1; iLM <= lmN; ++iLM) {
          current_statement__ = 30;
          if (logical_eq(randomN, 1)) {
            current_statement__ = 28;
            assign(bH_ind, cons_list(index_uni(iLM), nil_index_list()),
              rep_vector(bH_mu[(iLM - 1)], randomN),
              "assigning variable bH_ind");
          } else {
            current_statement__ = 26;
            assign(bH_ind, cons_list(index_uni(iLM), nil_index_list()),
              add(bH_mu[(iLM - 1)],
                multiply(bH_sigma[(iLM - 1)], bH_rnd[(iLM - 1)])),
              "assigning variable bH_ind");
          }}
        current_statement__ = 52;
        for (int iT = 1; iT <= rowsN; ++iT) {
          current_statement__ = 37;
          if (run_start[(iT - 1)]) {
            current_statement__ = 33;
            assign(current_history, nil_index_list(),
              to_vector(history_starting_values),
              "assigning variable current_history");
            current_statement__ = 34;
            tau = (session_tmean[(iT - 1)] *
                    tau_ind[(irandom[(iT - 1)] - 1)]);
            current_statement__ = 35;
            assign(level, nil_index_list(), stan::math::to_matrix(
              std::vector<Eigen::Matrix<local_scalar_t__, 1, -1>>{
              (Eigen::Matrix<local_scalar_t__,1,-1>(3) << 1, 0,
              mixed_state_ind[(irandom[(iT - 1)] - 1)]).finished(),
              (Eigen::Matrix<local_scalar_t__,1,-1>(3) << 0, 1,
              mixed_state_ind[(irandom[(iT - 1)] - 1)]).finished()}),
              "assigning variable level");
          } 
          current_statement__ = 47;
          if (logical_eq(is_used[(iT - 1)], 1)) {
            current_statement__ = 38;
            dH = (current_history[((3 - istate[(iT - 1)]) - 1)] -
                   current_history[(istate[(iT - 1)] - 1)]);
            current_statement__ = 44;
            for (int iLM = 1; iLM <= lmN; ++iLM) {
              current_statement__ = 39;
              assign(lm_param,
                cons_list(index_uni(iLM),
                  cons_list(index_uni(iC), nil_index_list())),
                (a[(iLM - 1)][(irandom[(iT - 1)] - 1)] +
                  (bH_ind[(iLM - 1)][(irandom[(iT - 1)] - 1)] * dH)),
                "assigning variable lm_param");
              current_statement__ = 42;
              if (logical_gt(fixedN, 0)) {
                current_statement__ = 40;
                assign(lm_param,
                  cons_list(index_uni(iLM),
                    cons_list(index_uni(iC), nil_index_list())),
                  (lm_param[(iLM - 1)][(iC - 1)] +
                    sum(
                      elt_multiply(bF[(iLM - 1)],
                        rvalue(fixed,
                          cons_list(index_uni(iT), nil_index_list()),
                          "fixed")))), "assigning variable lm_param");
              } }
            current_statement__ = 45;
            iC = (iC + 1);
          } 
          current_statement__ = 50;
          for (int iState = 1; iState <= 2; ++iState) {
            current_statement__ = 48;
            assign(current_history,
              cons_list(index_uni(iState), nil_index_list()),
              (rvalue(level,
                 cons_list(index_uni(iState),
                   cons_list(index_uni(istate[(iT - 1)]), nil_index_list())),
                 "level") +
                ((current_history[(iState - 1)] -
                   rvalue(level,
                     cons_list(index_uni(iState),
                       cons_list(index_uni(istate[(iT - 1)]),
                         nil_index_list())), "level")) *
                  stan::math::exp((-duration[(iT - 1)] / tau)))),
              "assigning variable current_history");}}
      }
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= clearN; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= lmN; ++sym2__) {
            vars__.emplace_back(lm_param[(sym2__ - 1)][(sym1__ - 1)]);}}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, 1> log_lik;
      log_lik = Eigen::Matrix<double, -1, 1>(clearN);
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 66;
      if (logical_eq(family, lGamma)) {
        current_statement__ = 64;
        for (int iC = 1; iC <= clearN; ++iC) {
          current_statement__ = 63;
          assign(log_lik, cons_list(index_uni(iC), nil_index_list()),
            gamma_lpdf<false>(clear_duration[(iC - 1)],
              stan::math::exp(lm_param[(1 - 1)][(iC - 1)]),
              (1 / stan::math::exp(lm_param[(2 - 1)][(iC - 1)]))),
            "assigning variable log_lik");}
      } else {
        current_statement__ = 62;
        if (logical_eq(family, lLogNormal)) {
          current_statement__ = 60;
          for (int iC = 1; iC <= clearN; ++iC) {
            current_statement__ = 59;
            assign(log_lik, cons_list(index_uni(iC), nil_index_list()),
              lognormal_lpdf<false>(clear_duration[(iC - 1)],
                stan::math::exp(lm_param[(1 - 1)][(iC - 1)]), sigma[(1 - 1)]),
              "assigning variable log_lik");}
        } else {
          current_statement__ = 58;
          if (logical_eq(family, lNormal)) {
            current_statement__ = 56;
            for (int iC = 1; iC <= clearN; ++iC) {
              current_statement__ = 55;
              assign(log_lik, cons_list(index_uni(iC), nil_index_list()),
                normal_lpdf<false>(clear_duration[(iC - 1)],
                  lm_param[(1 - 1)][(iC - 1)], sigma[(1 - 1)]),
                "assigning variable log_lik");}
          } 
        }
      }
      for (int sym1__ = 1; sym1__ <= clearN; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> tau_mu;
      tau_mu = Eigen::Matrix<double, -1, 1>(tau_mu_size);
      stan::math::fill(tau_mu, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> tau_mu_flat__;
        current_statement__ = 1;
        assign(tau_mu_flat__, nil_index_list(), context__.vals_r("tau_mu"),
          "assigning variable tau_mu_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= tau_mu_size; ++sym1__) {
          current_statement__ = 1;
          assign(tau_mu, cons_list(index_uni(sym1__), nil_index_list()),
            tau_mu_flat__[(pos__ - 1)], "assigning variable tau_mu");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> tau_sigma;
      tau_sigma = Eigen::Matrix<double, -1, 1>(tau_sigma_size);
      stan::math::fill(tau_sigma, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> tau_sigma_flat__;
        current_statement__ = 2;
        assign(tau_sigma_flat__, nil_index_list(),
          context__.vals_r("tau_sigma"),
          "assigning variable tau_sigma_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= tau_sigma_size; ++sym1__) {
          current_statement__ = 2;
          assign(tau_sigma, cons_list(index_uni(sym1__), nil_index_list()),
            tau_sigma_flat__[(pos__ - 1)], "assigning variable tau_sigma");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> tau_sigma_free__;
      tau_sigma_free__ = Eigen::Matrix<double, -1, 1>(tau_sigma_size);
      stan::math::fill(tau_sigma_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= tau_sigma_size; ++sym1__) {
        current_statement__ = 2;
        assign(tau_sigma_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(tau_sigma[(sym1__ - 1)], 0),
          "assigning variable tau_sigma_free__");}
      Eigen::Matrix<double, -1, 1> tau_rnd;
      tau_rnd = Eigen::Matrix<double, -1, 1>(tau_rnd_size);
      stan::math::fill(tau_rnd, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> tau_rnd_flat__;
        current_statement__ = 3;
        assign(tau_rnd_flat__, nil_index_list(), context__.vals_r("tau_rnd"),
          "assigning variable tau_rnd_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= tau_rnd_size; ++sym1__) {
          current_statement__ = 3;
          assign(tau_rnd, cons_list(index_uni(sym1__), nil_index_list()),
            tau_rnd_flat__[(pos__ - 1)], "assigning variable tau_rnd");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> mixed_state_mu;
      mixed_state_mu = Eigen::Matrix<double, -1, 1>(mixed_state_mu_size);
      stan::math::fill(mixed_state_mu, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mixed_state_mu_flat__;
        current_statement__ = 4;
        assign(mixed_state_mu_flat__, nil_index_list(),
          context__.vals_r("mixed_state_mu"),
          "assigning variable mixed_state_mu_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= mixed_state_mu_size; ++sym1__) {
          current_statement__ = 4;
          assign(mixed_state_mu,
            cons_list(index_uni(sym1__), nil_index_list()),
            mixed_state_mu_flat__[(pos__ - 1)],
            "assigning variable mixed_state_mu");
          current_statement__ = 4;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> mixed_state_sigma;
      mixed_state_sigma = Eigen::Matrix<double, -1, 1>(mixed_state_sigma_size);
      stan::math::fill(mixed_state_sigma, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mixed_state_sigma_flat__;
        current_statement__ = 5;
        assign(mixed_state_sigma_flat__, nil_index_list(),
          context__.vals_r("mixed_state_sigma"),
          "assigning variable mixed_state_sigma_flat__");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= mixed_state_sigma_size; ++sym1__) {
          current_statement__ = 5;
          assign(mixed_state_sigma,
            cons_list(index_uni(sym1__), nil_index_list()),
            mixed_state_sigma_flat__[(pos__ - 1)],
            "assigning variable mixed_state_sigma");
          current_statement__ = 5;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> mixed_state_sigma_free__;
      mixed_state_sigma_free__ = Eigen::Matrix<double, -1, 1>(mixed_state_sigma_size);
      stan::math::fill(mixed_state_sigma_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= mixed_state_sigma_size; ++sym1__) {
        current_statement__ = 5;
        assign(mixed_state_sigma_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(mixed_state_sigma[(sym1__ - 1)], 0),
          "assigning variable mixed_state_sigma_free__");}
      Eigen::Matrix<double, -1, 1> mixed_state_rnd;
      mixed_state_rnd = Eigen::Matrix<double, -1, 1>(mixed_state_rnd_size);
      stan::math::fill(mixed_state_rnd, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mixed_state_rnd_flat__;
        current_statement__ = 6;
        assign(mixed_state_rnd_flat__, nil_index_list(),
          context__.vals_r("mixed_state_rnd"),
          "assigning variable mixed_state_rnd_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= mixed_state_rnd_size; ++sym1__) {
          current_statement__ = 6;
          assign(mixed_state_rnd,
            cons_list(index_uni(sym1__), nil_index_list()),
            mixed_state_rnd_flat__[(pos__ - 1)],
            "assigning variable mixed_state_rnd");
          current_statement__ = 6;
          pos__ = (pos__ + 1);}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> a;
      a = std::vector<Eigen::Matrix<double, -1, 1>>(lmN, Eigen::Matrix<double, -1, 1>(randomN));
      stan::math::fill(a, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> a_flat__;
        current_statement__ = 7;
        assign(a_flat__, nil_index_list(), context__.vals_r("a"),
          "assigning variable a_flat__");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= randomN; ++sym1__) {
          current_statement__ = 7;
          for (int sym2__ = 1; sym2__ <= lmN; ++sym2__) {
            current_statement__ = 7;
            assign(a,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              a_flat__[(pos__ - 1)], "assigning variable a");
            current_statement__ = 7;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> bH_mu;
      bH_mu = Eigen::Matrix<double, -1, 1>(lmN);
      stan::math::fill(bH_mu, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> bH_mu_flat__;
        current_statement__ = 8;
        assign(bH_mu_flat__, nil_index_list(), context__.vals_r("bH_mu"),
          "assigning variable bH_mu_flat__");
        current_statement__ = 8;
        pos__ = 1;
        current_statement__ = 8;
        for (int sym1__ = 1; sym1__ <= lmN; ++sym1__) {
          current_statement__ = 8;
          assign(bH_mu, cons_list(index_uni(sym1__), nil_index_list()),
            bH_mu_flat__[(pos__ - 1)], "assigning variable bH_mu");
          current_statement__ = 8;
          pos__ = (pos__ + 1);}
      }
      std::vector<double> bH_sigma;
      bH_sigma = std::vector<double>(bH_sigma_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 9;
      assign(bH_sigma, nil_index_list(), context__.vals_r("bH_sigma"),
        "assigning variable bH_sigma");
      std::vector<double> bH_sigma_free__;
      bH_sigma_free__ = std::vector<double>(bH_sigma_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= bH_sigma_1dim__; ++sym1__) {
        current_statement__ = 9;
        assign(bH_sigma_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(bH_sigma[(sym1__ - 1)], 0),
          "assigning variable bH_sigma_free__");}
      std::vector<Eigen::Matrix<double, -1, 1>> bH_rnd;
      bH_rnd = std::vector<Eigen::Matrix<double, -1, 1>>(bH_rnd_1dim__, Eigen::Matrix<double, -1, 1>(bH_rnd_2dim__));
      stan::math::fill(bH_rnd, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> bH_rnd_flat__;
        current_statement__ = 10;
        assign(bH_rnd_flat__, nil_index_list(), context__.vals_r("bH_rnd"),
          "assigning variable bH_rnd_flat__");
        current_statement__ = 10;
        pos__ = 1;
        current_statement__ = 10;
        for (int sym1__ = 1; sym1__ <= bH_rnd_2dim__; ++sym1__) {
          current_statement__ = 10;
          for (int sym2__ = 1; sym2__ <= bH_rnd_1dim__; ++sym2__) {
            current_statement__ = 10;
            assign(bH_rnd,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              bH_rnd_flat__[(pos__ - 1)], "assigning variable bH_rnd");
            current_statement__ = 10;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, 1, -1>> bF;
      bF = std::vector<Eigen::Matrix<double, 1, -1>>(bF_1dim__, Eigen::Matrix<double, 1, -1>(fixedN));
      stan::math::fill(bF, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> bF_flat__;
        current_statement__ = 11;
        assign(bF_flat__, nil_index_list(), context__.vals_r("bF"),
          "assigning variable bF_flat__");
        current_statement__ = 11;
        pos__ = 1;
        current_statement__ = 11;
        for (int sym1__ = 1; sym1__ <= fixedN; ++sym1__) {
          current_statement__ = 11;
          for (int sym2__ = 1; sym2__ <= bF_1dim__; ++sym2__) {
            current_statement__ = 11;
            assign(bF,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              bF_flat__[(pos__ - 1)], "assigning variable bF");
            current_statement__ = 11;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> sigma;
      sigma = Eigen::Matrix<double, -1, 1>(varianceN);
      stan::math::fill(sigma, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sigma_flat__;
        current_statement__ = 12;
        assign(sigma_flat__, nil_index_list(), context__.vals_r("sigma"),
          "assigning variable sigma_flat__");
        current_statement__ = 12;
        pos__ = 1;
        current_statement__ = 12;
        for (int sym1__ = 1; sym1__ <= varianceN; ++sym1__) {
          current_statement__ = 12;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            sigma_flat__[(pos__ - 1)], "assigning variable sigma");
          current_statement__ = 12;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> sigma_free__;
      sigma_free__ = Eigen::Matrix<double, -1, 1>(varianceN);
      stan::math::fill(sigma_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= varianceN; ++sym1__) {
        current_statement__ = 12;
        assign(sigma_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma[(sym1__ - 1)], 0),
          "assigning variable sigma_free__");}
      for (int sym1__ = 1; sym1__ <= tau_mu_size; ++sym1__) {
        vars__.emplace_back(tau_mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= tau_sigma_size; ++sym1__) {
        vars__.emplace_back(tau_sigma_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= tau_rnd_size; ++sym1__) {
        vars__.emplace_back(tau_rnd[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= mixed_state_mu_size; ++sym1__) {
        vars__.emplace_back(mixed_state_mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= mixed_state_sigma_size; ++sym1__) {
        vars__.emplace_back(mixed_state_sigma_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= mixed_state_rnd_size; ++sym1__) {
        vars__.emplace_back(mixed_state_rnd[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= lmN; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= randomN; ++sym2__) {
          vars__.emplace_back(a[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= lmN; ++sym1__) {
        vars__.emplace_back(bH_mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= bH_sigma_1dim__; ++sym1__) {
        vars__.emplace_back(bH_sigma_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= bH_rnd_1dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= bH_rnd_2dim__; ++sym2__) {
          vars__.emplace_back(bH_rnd[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= bF_1dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= fixedN; ++sym2__) {
          vars__.emplace_back(bF[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= varianceN; ++sym1__) {
        vars__.emplace_back(sigma_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("tau_mu");
    names__.emplace_back("tau_sigma");
    names__.emplace_back("tau_rnd");
    names__.emplace_back("mixed_state_mu");
    names__.emplace_back("mixed_state_sigma");
    names__.emplace_back("mixed_state_rnd");
    names__.emplace_back("a");
    names__.emplace_back("bH_mu");
    names__.emplace_back("bH_sigma");
    names__.emplace_back("bH_rnd");
    names__.emplace_back("bF");
    names__.emplace_back("sigma");
    names__.emplace_back("lm_param");
    names__.emplace_back("log_lik");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(tau_mu_size)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(tau_sigma_size)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(tau_rnd_size)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(mixed_state_mu_size)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(mixed_state_sigma_size)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(mixed_state_rnd_size)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(lmN),
                                             static_cast<size_t>(randomN)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(lmN)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(bH_sigma_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(bH_rnd_1dim__)
                                             ,
                                             static_cast<size_t>(bH_rnd_2dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(bF_1dim__),
                                             static_cast<size_t>(fixedN)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(varianceN)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(lmN),
                                             static_cast<size_t>(clearN)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(clearN)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= tau_mu_size; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "tau_mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= tau_sigma_size; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "tau_sigma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= tau_rnd_size; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "tau_rnd" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= mixed_state_mu_size; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mixed_state_mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= mixed_state_sigma_size; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mixed_state_sigma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= mixed_state_rnd_size; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mixed_state_rnd" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= randomN; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= lmN; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "a" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= lmN; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "bH_mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= bH_sigma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "bH_sigma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= bH_rnd_2dim__; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= bH_rnd_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "bH_rnd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= fixedN; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= bF_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "bF" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= varianceN; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= clearN; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= lmN; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "lm_param" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= clearN; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= tau_mu_size; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "tau_mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= tau_sigma_size; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "tau_sigma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= tau_rnd_size; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "tau_rnd" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= mixed_state_mu_size; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mixed_state_mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= mixed_state_sigma_size; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mixed_state_sigma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= mixed_state_rnd_size; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mixed_state_rnd" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= randomN; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= lmN; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "a" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= lmN; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "bH_mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= bH_sigma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "bH_sigma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= bH_rnd_2dim__; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= bH_rnd_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "bH_rnd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= fixedN; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= bF_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "bF" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= varianceN; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= clearN; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= lmN; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "lm_param" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= clearN; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"tau_mu\",\"type\":{\"name\":\"vector\",\"length\":" << tau_mu_size << "},\"block\":\"parameters\"},{\"name\":\"tau_sigma\",\"type\":{\"name\":\"vector\",\"length\":" << tau_sigma_size << "},\"block\":\"parameters\"},{\"name\":\"tau_rnd\",\"type\":{\"name\":\"vector\",\"length\":" << tau_rnd_size << "},\"block\":\"parameters\"},{\"name\":\"mixed_state_mu\",\"type\":{\"name\":\"vector\",\"length\":" << mixed_state_mu_size << "},\"block\":\"parameters\"},{\"name\":\"mixed_state_sigma\",\"type\":{\"name\":\"vector\",\"length\":" << mixed_state_sigma_size << "},\"block\":\"parameters\"},{\"name\":\"mixed_state_rnd\",\"type\":{\"name\":\"vector\",\"length\":" << mixed_state_rnd_size << "},\"block\":\"parameters\"},{\"name\":\"a\",\"type\":{\"name\":\"array\",\"length\":" << lmN << ",\"element_type\":{\"name\":\"vector\",\"length\":" << randomN << "}},\"block\":\"parameters\"},{\"name\":\"bH_mu\",\"type\":{\"name\":\"vector\",\"length\":" << lmN << "},\"block\":\"parameters\"},{\"name\":\"bH_sigma\",\"type\":{\"name\":\"array\",\"length\":" << bH_sigma_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"bH_rnd\",\"type\":{\"name\":\"array\",\"length\":" << bH_rnd_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << bH_rnd_2dim__ << "}},\"block\":\"parameters\"},{\"name\":\"bF\",\"type\":{\"name\":\"array\",\"length\":" << bF_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << fixedN << "}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"vector\",\"length\":" << varianceN << "},\"block\":\"parameters\"},{\"name\":\"lm_param\",\"type\":{\"name\":\"array\",\"length\":" << lmN << ",\"element_type\":{\"name\":\"vector\",\"length\":" << clearN << "}},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << clearN << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"tau_mu\",\"type\":{\"name\":\"vector\",\"length\":" << tau_mu_size << "},\"block\":\"parameters\"},{\"name\":\"tau_sigma\",\"type\":{\"name\":\"vector\",\"length\":" << tau_sigma_size << "},\"block\":\"parameters\"},{\"name\":\"tau_rnd\",\"type\":{\"name\":\"vector\",\"length\":" << tau_rnd_size << "},\"block\":\"parameters\"},{\"name\":\"mixed_state_mu\",\"type\":{\"name\":\"vector\",\"length\":" << mixed_state_mu_size << "},\"block\":\"parameters\"},{\"name\":\"mixed_state_sigma\",\"type\":{\"name\":\"vector\",\"length\":" << mixed_state_sigma_size << "},\"block\":\"parameters\"},{\"name\":\"mixed_state_rnd\",\"type\":{\"name\":\"vector\",\"length\":" << mixed_state_rnd_size << "},\"block\":\"parameters\"},{\"name\":\"a\",\"type\":{\"name\":\"array\",\"length\":" << lmN << ",\"element_type\":{\"name\":\"vector\",\"length\":" << randomN << "}},\"block\":\"parameters\"},{\"name\":\"bH_mu\",\"type\":{\"name\":\"vector\",\"length\":" << lmN << "},\"block\":\"parameters\"},{\"name\":\"bH_sigma\",\"type\":{\"name\":\"array\",\"length\":" << bH_sigma_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"bH_rnd\",\"type\":{\"name\":\"array\",\"length\":" << bH_rnd_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << bH_rnd_2dim__ << "}},\"block\":\"parameters\"},{\"name\":\"bF\",\"type\":{\"name\":\"array\",\"length\":" << bF_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << fixedN << "}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"vector\",\"length\":" << varianceN << "},\"block\":\"parameters\"},{\"name\":\"lm_param\",\"type\":{\"name\":\"array\",\"length\":" << lmN << ",\"element_type\":{\"name\":\"vector\",\"length\":" << clearN << "}},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << clearN << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_historylm_namespace::model_historylm;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_historylm_namespace::profiles__;
}
#endif
#endif
