% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_jive.R
\encoding{UTF-8}
\name{plot_jive}
\alias{plot_jive}
\title{plot input data from a jive object}
\usage{
plot_jive(jive, col.map = NULL, col = "lightgrey",
  show.tip.label = TRUE, show.models = TRUE,
  direction = "rightwards", trait.lab = "x", trait.lim = NULL,
  srt.label = 0, c.reg = NULL, tip.color = "#000000", ...)
}
\arguments{
\item{jive}{a jive object built with the function \code{\link{make_jive}}}

\item{col.map}{a vector of mode character indicating colors of the edges for the map ploting. It should be of same size than the number of regimes}

\item{col}{a character indicating the color of the vioplots}

\item{show.tip.label}{a logical indicating whether to show the tip labels on the phylogeny (defaults to TRUE, i.e. the labels are shown).}

\item{show.models}{a logical indicating whether to show details about model specification in the jive object.}

\item{direction}{a character string specifying the direction of the tree. Two values are possible: "rightwards" (the default) and "upwards".}

\item{trait.lab}{a charachter specifying the axis label for the traits}

\item{trait.lim}{a vector of mode numeric indicating the limits for trait ploting}

\item{srt.label}{an integer indicating the string rotation in degrees for the tip labels}

\item{c.reg}{a real number indicating where to plot the names of the regimes. The names are not plotted if c.reg == NULL.}

\item{tip.color}{the colours used for the tip labels, eventually recycled.}

\item{...}{additional parameters that can be passed to \code{\link{vioplot}}}
}
\description{
This function plots the phylogenetic tree, the trait data and the map used as an input for a jive analysis
}
\examples{
data(Anolis_traits)
data(Anolis_tree)
data(Anolis_map)

colnames(Anolis_map) <- c("Hispaniola", "Cuba")
my.jive <- make_jive(Anolis_tree, Anolis_traits[,-3], 
 model.priors = list(m="BM", v = "OU"))
par(cex.lab = .8, cex.axis = .8, las = 1, mgp = c(2,0.5,0))
plot_jive(jive = my.jive, show.tip.label = TRUE, 
trait.lab = "Snout to vent length (cm)", srt.label = 0, c.reg = 2)

my.jive <- make_jive(Anolis_tree, Anolis_traits[,-3], Anolis_map,
 model.priors = list(m = "BM", v = c("OU", "theta")))
par(cex.lab = .8, cex.axis = .8, las = 1, mgp = c(2,0.5,0))
plot_jive(jive = my.jive, show.tip.label = TRUE, c.reg = 2,
 trait.lab = "Snout to vent length (cm)", srt.label = 70, direction = "upwards")
 
}
\author{
Theo Gaboriau
}
