% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeMixtureSummaries.R
\name{SingVarRiskSummaries}
\alias{SingVarRiskSummaries}
\title{Single Variable Risk Summaries}
\usage{
SingVarRiskSummaries(fit, y = NULL, Z = NULL, X = NULL,
  which.z = 1:ncol(Z), qs.diff = c(0.25, 0.75), q.fixed = c(0.25, 0.5,
  0.75), preds.method = "approx", sel = NULL, z.names = colnames(Z), ...)
}
\arguments{
\item{fit}{An object containing the results returned by a the \code{kmbayes} function}

\item{y}{a vector of outcome data of length \code{n}.}

\item{Z}{an \code{n}-by-\code{M} matrix of predictor variables to be included in the \code{h} function. Each row represents an observation and each column represents an predictor.}

\item{X}{an \code{n}-by-\code{K} matrix of covariate data where each row represents an observation and each column represents a covariate. Should not contain an intercept column.}

\item{which.z}{vector indicating which variables (columns of \code{Z}) for which the summary should be computed}

\item{qs.diff}{vector indicating the two quantiles \code{q_1} and \code{q_2} at which to compute \code{h(z_{q2}) - h(z_{q1})}}

\item{q.fixed}{vector of quantiles at which to fix the remaining predictors in \code{Z}}

\item{preds.method}{method for obtaining posterior summaries at a vector of new point. Currently only implemented for \code{preds.method = "approx"}}

\item{sel}{logical expression indicating samples to keep; defaults to keeping the second half of all samples}

\item{z.names}{optional vector of names for the columns of \code{z}}

\item{...}{other argumentd to pass on to the prediction function}
}
\description{
Compute summaries of the risks associated with a change in a single variable in \code{Z} from a single level (quantile) to a second level (quantile), for the other variables in \code{Z} fixed to a specific level (quantile)
}

