% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blandr.ggplot.r
\name{blandr.ggplot}
\alias{blandr.ggplot}
\title{Bland-Altman plotting function, using ggplot2}
\usage{
blandr.ggplot(statistics.results, method1name = "Method 1",
  method2name = "Method 2",
  plotTitle = "Bland-Altman plot for comparison of 2 methods",
  ciDisplay = TRUE, ciShading = TRUE, normalLow = FALSE,
  normalHigh = FALSE)
}
\arguments{
\item{statistics.results}{A list of statistics generated by the blandr.statistics function: see the function's return list to see what variables are passed to this function}

\item{method1name}{(Optional) Plotting name for 1st method, default "Method 1"}

\item{method2name}{(Optional) Plotting name for 2nd method, default "Method 2"}

\item{plotTitle}{(Optional) Title name, default "Bland-Altman plot for comparison of 2 methods"}

\item{ciDisplay}{(Optional) TRUE/FALSE switch to plot confidence intervals for bias and limits of agreement, default=TRUE}

\item{ciShading}{(Optional) TRUE/FALSE switch to plot confidence interval shading to plot, default=TRUE}

\item{normalLow}{(Optional) If there is a normal range, entering a continuous variable will plot a vertical line on the plot to indicate its lower boundary}

\item{normalHigh}{(Optional) If there is a normal range, entering a continuous variable will plot a vertical line on the plot to indicate its higher boundary}
}
\value{
ba.plot Returns a ggplot data set that can then be plotted
}
\description{
Draws a Bland-Altman plot using data calculated using the other functions, using ggplot2
}
\examples{
# Generates two random measurements
measurement1 <- rnorm(100)
measurement2 <- rnorm(100)

# Generates a ggplot
# Do note the ggplot function wasn't meant to be used on it's own
# and is generally called via the bland.altman.display.and.draw function

# Passes data to the blandr.statistics function to generate Bland-Altman statistics
statistics.results <- blandr.statistics( measurement1 , measurement2 )

# Generates a ggplot, with no optional arguments
blandr.ggplot( statistics.results )

# Generates a ggplot, with title changed
blandr.ggplot( statistics.results , plotTitle = "Bland-Altman example plot" )

# Generates a ggplot, with title changed, and confidence intervals off
blandr.ggplot( statistics.results , plotTitle = "Bland-Altman example plot" ,
ciDisplay = FALSE , ciShading = FALSE )

}
\author{
Deepankar Datta <deepankardatta@nhs.net>
}
