% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blandr.proportional.bias.r
\name{blandr.proportional.bias}
\alias{blandr.proportional.bias}
\title{Bland-Altman function to look for proportional bias}
\usage{
blandr.proportional.bias(method1, method2, method1name = "Method 1",
  method2name = "Method 2",
  plotTitle = "Bland-Altman plot with regression line", sig.level = 0.95,
  LoA.mode = 1, ciDisplay = FALSE, ciShading = FALSE, normalLow = FALSE,
  normalHigh = FALSE, lowest_y_axis = FALSE, highest_y_axis = FALSE)
}
\arguments{
\item{method1}{A list of numbers.}

\item{method2}{A list of numbers.}

\item{method1name}{(Optional) Plotting name for 1st method, default "Method 1"}

\item{method2name}{(Optional) Plotting name for 2nd method, default "Method 2"}

\item{plotTitle}{(Optional) Title name, default "Bland-Altman plot for comparison of 2 methods"}

\item{sig.level}{(Optional) Two-tailed significance level. Expressed from 0 to 1. Defaults to 0.95.}

\item{LoA.mode}{(Optional) Switch to change how accurately the limits of agreement (LoA) are calculated from the bias and its standard deviation. The default is LoA.mode=1 which calculates LoA with the more accurate 1.96x multiplier. LoA.mode=2 uses the 2x multiplier which was used in the original papers. This should really be kept at default, except to double check calculations in older papers.}

\item{ciDisplay}{(Optional) TRUE/FALSE switch to plot confidence intervals for bias and limits of agreement, default=TRUE}

\item{ciShading}{(Optional) TRUE/FALSE switch to plot confidence interval shading to plot, default=TRUE}

\item{normalLow}{(Optional) If there is a normal range, entering a continuous variable will plot a vertical line on the plot to indicate its lower boundary}

\item{normalHigh}{(Optional) If there is a normal range, entering a continuous variable will plot a vertical line on the plot to indicate its higher boundary}

\item{lowest_y_axis}{(Optional) Defaults to NULL If given a continuous variable will use this as the lower boundary of the y axis. Useful if need multiple plots with equivalent y-axes.}

\item{highest_y_axis}{(Optional) Defaults to NULL If given a continuous variable will use this as the upper boundary of the y axis. Useful if need multiple plots with equivalent y-axes.}
}
\description{
Draws a Bland-Altman chart with regression line to look at proportional bias. Only uses ggplot2.
}
\examples{
# Generates two random measurements
measurement1 <- rnorm(100)
measurement2 <- rnorm(100)

# Call the function, with no optional arguments
blandr.proportional.bias( measurement1 , measurement2 )

# Call the function, with title
blandr.proportional.bias( measurement1 , measurement2 , plotTitle = 'Bland-Altman example plot' )

}
\references{
http://rforpublichealth.blogspot.co.uk/2013/11/ggplot2-cheatsheet-for-scatterplots.html
}
\author{
Deepankar Datta <deepankardatta@nhs.net>
}
