% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_coxlps_plot.R
\name{plot.coxlps}
\alias{plot.coxlps}
\title{Plot baseline hazard and survival curves from a coxlps object.}
\usage{
\method{plot}{coxlps}(x, S0 = TRUE, h0 = TRUE, cred.int = 0.95, overlay.km = FALSE,
     plot.cred = FALSE, np = 50, show.legend = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{coxlps}.}

\item{S0}{Logical. Should the estimated baseline survival be plotted?}

\item{h0}{Logical. Should the estimated baseline hazard be plotted?}

\item{cred.int}{The level for an approximate pointwise credible interval
to be computed for the baseline curves. Default is 0.95.}

\item{overlay.km}{A logical value indicating whether the Kaplan-Meier
estimate should be plotted together with the smooth baseline survival
curve. The default is \code{FALSE}.}

\item{plot.cred}{Logical. Should the credible intervals be plotted ?
Default is \code{FALSE}.}

\item{np}{The number of points used to plot the smooth baseline
functions. Default is 50 and allowed values are
between 20 and 200.}

\item{show.legend}{Logical. Should a legend be displayed?}

\item{...}{Further arguments to be passed to plot.}
}
\description{
Produces a plot of the baseline hazard and/or survival based
 on a coxlps object.
}
\details{
Plots for the baseline hazard and survival curves are computed on
  a grid (of length \code{np}) between 0 and the 99th percentile of follow-up
  times. When \code{plot.cred} is \code{FALSE}, the fit omits to compute the
  approximate pointwise credible intervals for plotting and hence is less
  computationally intensive. Vertical ticks on the x-axis correspond to the
  observed follow-up times.
}
\examples{


## Simulate survival data
set.seed(6)
betas <- c(0.35, -0.20, 0.05, 0.80) # Regression coefficients
data <- simsurvdata(a = 1.8, b = 2, n = 200, betas = betas, censperc = 25)
simdat <- data$survdata

# Fit model
fit <- coxlps(Surv(time, delta) ~ x1 + x2 + x3 + x4, data = simdat)
plot(fit, h0 = FALSE, S0 = TRUE, overlay.km = FALSE, show.legend = FALSE)
domt <- seq(0, 5.5, length = 500)
lines(domt, data$S0(domt), type = "l", col = "red")
legend("topright", c("Bayesian LPS", "Target"), col = c("black", "red"),
       lty = c(1, 1), bty = "n", cex = 0.8)

}
\seealso{
\code{\link{coxlps}} \code{\link{coxlps.object}}
}
\author{
Gressani Oswaldo \email{oswaldo_gressani@hotmail.fr}.
}
