% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/send_email_out.R
\name{send_email_out}
\alias{send_email_out}
\title{Send an email message}
\usage{
send_email_out(message, subject = NULL, from = NULL, recipients = NULL,
  creds_file = NULL, sender = NULL, host = NULL, port = NULL,
  user = NULL, password = NULL, use_ssl = TRUE, use_tls = FALSE,
  authenticate = TRUE, debug = FALSE)
}
\arguments{
\item{message}{the email message object,
as created by the \code{compose_email()}
function. The object's class is
\code{email_message}}

\item{subject}{the subject of the
email.}

\item{from}{the email address of the
sender. This does not have to be
the same email that is associated with
the account actually sending the message.}

\item{recipients}{a vector of email
addresses.}

\item{creds_file}{an optional path to
an email credentials file. This file
must be created by the
\code{create_email_creds_file}
function.}

\item{sender}{the sender name.}

\item{host}{the email host.}

\item{port}{the port associated with
the email account.}

\item{user}{the username associated
with the email account.}

\item{password}{the password associated
with the email account.}

\item{use_ssl}{a logical value to
indicate whether to use SSL.}

\item{use_tls}{a logical value to
indicate whether to use TLS.}

\item{authenticate}{a logical value to
indicate whether to use authenication.}

\item{debug}{a logical value to indicate
whether a detailed debug information
should be printed to the console
during sending of email.}
}
\description{
Send an email message to one
or more recipients.
}
