% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_articles.R
\name{article}
\alias{article}
\title{Specify the components of an article}
\usage{
article(image = NULL, title = NULL, content = NULL, link = NULL)
}
\arguments{
\item{image}{An optional URL pointing to an image resource.}

\item{title}{An optional title for the article.}

\item{content}{An optional paragraph of text for the article.}

\item{link}{An optional link to apply to the content elements.}
}
\description{
The \code{article()} function is used exclusively within \code{block_articles()},
and having one, two, or three calls will arrange the articles in a row (or as
a column of articles at lower screen widths).
}
\examples{
# We can define an article with a link
# to an image, title text, some content,
# and a link to relevant content
article <-
  article(
    image = "https://i.imgur.com/dxSXzGb.jpg",
    title = "Hong Kong",
    content =
      "Once home to fishermen and farmers, \\\\
      modern Hong Kong is a teeming, \\\\
      commercially-vibrant metropolis where \\\\
      Chinese and Western influences fuse.",
    link = "http://www.discoverhongkong.com"
  )

if (interactive()) article
}
