% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_credentials.R
\name{delete_credential_key}
\alias{delete_credential_key}
\title{Delete a single \strong{blastula} credential key}
\usage{
delete_credential_key(id)
}
\arguments{
\item{id}{The identifying label for the credential key. Use the same \code{id}
that was used to create the key with the \code{\link[=create_smtp_creds_key]{create_smtp_creds_key()}}
function.}
}
\description{
It may be important to delete a credential key and the
\code{delete_credential_key()} function makes this possible. To understand which
keys are available in the key-value store (and to get their \code{id} values), use
the \code{\link[=view_credential_keys]{view_credential_keys()}} function.
}
\details{
Support for using the \code{delete_credential_key()} function (and for doing any
credential key management) is provided through the \strong{keyring} package. This
function cannot be used without that package being available on the system.
We can use \code{install.packages("keyring")} to install \strong{keyring}.
}
\examples{
# Delete the credential key with
# the `id` value of "outlook"

# delete_credential_key("outlook")

}
