% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Auxiliary_and_graphics_functions.R
\name{compute_chains_info}
\alias{compute_chains_info}
\title{compute_chains_info}
\usage{
compute_chains_info(chain, param)
}
\arguments{
\item{chain}{a list given by the \code{Bliss_Gibbs_Sampler} function.}

\item{param}{a list containing:
\describe{
\item{K}{a vector of integers, corresponding to the numbers of intervals for
      each covariate.}
\item{grids}{a numerical vector, the observation time points.}
\item{basis}{a vector of characters (optional) among : "uniform" (default),
      "epanechnikov", "gauss" and "triangular" which correspond to
      different basis functions to expand the coefficient function and the
      functional covariates.}
}}
}
\value{
Return a list containing the estimates of \code{mu} and \code{sigma_sq}, the
        Smooth estimate and the chain autocorrelation for \code{mu}, \code{sigma_sq} and \code{beta}.
}
\description{
Compute summaries of Gibbs Sampler chains.
}
\examples{
\donttest{
param_sim <- list(Q=1,
                  n=100,
                  p=c(50),
                  grids_lim=list(c(0,1)))
data <- sim(param_sim,verbose=TRUE)

param <- list(iter=5e2,
              K=c(3),
              n_chains = 3)
res_bliss <- fit_Bliss(data,param,verbose=TRUE,compute_density=FALSE,sann=FALSE)

param$grids <- data$grids
chains_info1 <- compute_chains_info(res_bliss$chains[[1]],param)
chains_info2 <- compute_chains_info(res_bliss$chains[[2]],param)
chains_info3 <- compute_chains_info(res_bliss$chains[[3]],param)

# Smooth estimates
ylim <- range(range(chains_info1$estimates$Smooth_estimate),
range(chains_info2$estimates$Smooth_estimate),
range(chains_info3$estimates$Smooth_estimate))
plot(data$grids[[1]],chains_info1$estimates$Smooth_estimate,type="l",ylim=ylim,
xlab="grid",ylab="")
lines(data$grids[[1]],chains_info2$estimates$Smooth_estimate,col=2)
lines(data$grids[[1]],chains_info3$estimates$Smooth_estimate,col=3)

# Autocorrelation
plot(chains_info1$autocorr_lag[,1],type="h")
}
}
