% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blkboxPlot.R
\name{cv.plot}
\alias{cv.plot}
\title{Crossfold Validation Performance Plot.}
\usage{
cv.plot(obj, metric = "AUROC", y_ranges = c(0, 1), title = "",
  type = "boxplot")
}
\arguments{
\item{obj}{An object produced by the blkboxCV function.}

\item{metric}{Which metric you wish to plot. Area under the Receiver operating curve = "AUROC", Accuracy = "ACC", Error rate = "ERR", Matthews correlation coefficient = "MCC", F-1 score = "F-1". default = c("AUROC")}

\item{y_ranges}{is the y axis limits for the plot, defaults to c(0,1). Must be a numeric vector with two entries. Invalid for barplots.}

\item{title}{the title to be adhered to the plot. Default is no title.}

\item{type}{The plot can be either a barplot or boxplot. For the barplot the consensus performance is used, for a boxplot consensus is false. If only one performance measure is found for each algorithm then it will be forced to a barplot. default = "boxplot", unless data is unsupported.}
}
\description{
Compares the performance of each algorithm in a boxplot OR barplot. Each holdout will contribute at least one data point to each algorithm.
}
\examples{
\donttest{
cv.plot(blkboxCV(...), metric = "AUROC", title = "Example Performance Barplot")
}
}
\author{
Zachary Davies, Boris Guennewig
}
\keyword{CV,}
\keyword{Plot,}
\keyword{barplot}
\keyword{boxplot,}
\keyword{ggplot2,}

