cat("\n\nRUnit test cases for blme::bglmer function\n\n");

# generated by:
if (FALSE) {
  set.seed(0);
  x.1 <- rnorm(20);
  x.2 <- rnorm(20);
  theta <- rnorm(4, 0, 2);
  eta <- 3 * x.1 + 2 * x.2 + rep(theta, rep(5, 4))
  mu <- exp(eta) / (1 + exp(eta))
  y <- rbinom(20, 1, mu)
}

test.blme.bglmer <- function()
{
  x.1 <- c(1.26295428488079, -0.326233360705649, 1.3297992629225, 1.2724293214294, 0.414641434456408, -1.53995004190371, -0.928567034713538, -0.29472044679056, -0.00576717274753696, 2.40465338885795, 0.76359346114046, -0.799009248989368, -1.14765700923635, -0.289461573688223, -0.299215117897316, -0.411510832795067, 0.252223448156132, -0.891921127284569, 0.435683299355719, -1.23753842192996);
  x.2 <- c(-0.224267885278309, 0.377395645981701, 0.133336360814841, 0.804189509744908, -0.0571067743838088, 0.503607972233726, 1.08576936214569, -0.69095383969683, -1.28459935387219, 0.046726172188352, -0.235706556439501, -0.542888255010254, -0.433310317456782, -0.649471646796233, 0.726750747385451, 1.1519117540872, 0.992160365445798, -0.429513109491881, 1.23830410085338, -0.279346281854269);

  y <- c(1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0);

  ff <- gl(4, 5);

  glmerFit  <-  glmer(y ~ x.1 + x.2 + (1 | ff), family=binomial());
  bglmerFit <- bglmer(y ~ x.1 + x.2 + (1 | ff), family=binomial(),
                      cov.prior = NULL, fixef.prior = NULL);

  checkEquals(as.numeric(unlist(glmerFit@ST)),
              as.numeric(unlist(bglmerFit@ST)));
  checkEquals(glmerFit@ranef, bglmerFit@ranef);
  checkEquals(glmerFit@fixef[-length(glmerFit@fixef)],    # off-by-one bug in glmer causes
              bglmerFit@fixef[-length(bglmerFit@fixef)]); # the last fixef to be wrong

  # I haven't yet hacked together ways of checking that bglmer will converge to the
  # right point, but as the priors just end up as penalities on the likelihood,
  # checking that the penalties are correct will have to be good enough for now.
  checkEquals(blme:::getPriorPenalty(bglmerFit), 0);
  
  bglmerFit <- blme:::setPrior(bglmerFit, cov.prior="gamma(2, 1, posterior.scale = 'sd')");
  priorPenalty <- -2 * dgamma(bglmerFit@ST[[1]][1], 2, 1, log=TRUE);
  checkEquals(blme:::getPriorPenalty(bglmerFit), priorPenalty);
  
  bglmerFit <- blme:::setPrior(bglmerFit, cov.prior="none",
                                fixef.prior="normal(sd = c(10, 2.5))");
  priorPenalty <- -2 * sum(dnorm(bglmerFit@fixef, rep(0, bglmerFit@dims[["p"]]),
                                 c(10, rep(2.5, bglmerFit@dims[["p"]] - 1)), log=TRUE));
  checkEquals(blme:::getPriorPenalty(bglmerFit), priorPenalty);


  checkException(blme:::parsePrior(bglmerFit, fixef.prior="normal(cov.scale = 'common')"));
}
