% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_strata.R
\name{prop_strata}
\alias{prop_strata}
\title{Stratified Proportion Estimate for Binomial Data}
\usage{
prop_strata(treatment, outcome, block)
}
\arguments{
\item{treatment}{vector. The vector with treatment assignment, 0 for control
and 1 for treatment group.}

\item{outcome}{vector. The vector with outcome, 0 for failure
and 1 for success. Must be the same length as treatment variable.}

\item{block}{vector. The vector with factor level of the block.
Must be same lenhth as treatment variable.}
}
\value{
the weighted mean of proportion difference (treatment - control).
}
\description{
Computing the proportion of treatment difference for
  stratified data. The stratification is done over time.
}
\examples{
set.seed(20999)
prop_strata(c(0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 0),
            c(0, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1),
            as.factor(rep(1:3, each = 5)))
}
