% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.hhj.R
\name{plot.hhj}
\alias{plot.hhj}
\title{Plot MSE Function for HHJ Algorithm}
\usage{
\method{plot}{hhj}(x, iter = NULL, ...)
}
\arguments{
\item{x}{an object of class 'hhj'}

\item{iter}{a vector of \code{hhj()} iterations to plot. \code{NULL}. All
iterations are plotted by default.}

\item{...}{
  Arguments passed on to \code{\link[base:plot]{base::plot}}
  \describe{
    \item{\code{y}}{the y coordinates of points in the plot, \emph{optional}
    if \code{x} is an appropriate structure.}
  }}
}
\value{
No return value, called for side effects
}
\description{
S3 Method for objects of class 'hhj'
}
\examples{

\donttest{
# Generate AR(1) time series
sim <- stats::arima.sim(list(order = c(1, 0, 0), ar = 0.5),
                        n = 500, innov = rnorm(500))

# Generate 'hhj' class object of optimal block length for series
hhj <- hhj(sim, sub_block_length = 10)

## S3 method for class 'hhj'
plot(hhj)
}

}
