% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_site}
\alias{check_site}
\alias{check_config}
\alias{check_gitignore}
\alias{check_hugo}
\alias{check_netlify}
\alias{check_content}
\title{Provide diagnostics for a website project}
\usage{
check_site()

check_config()

check_gitignore()

check_hugo()

check_netlify()

check_content()
}
\description{
The function \code{check_site()} runs all \code{check_*()} functions on this
page against a website project. See \sQuote{Details} for what each
\code{check_*()} function does.
}
\details{
\code{check_config()} checks the configuration file
  (\file{config.yaml} or \file{config.toml}) for settings such as
  \code{baseURL} and \code{ignoreFiles}.

\code{check_gitignore()} checks if necessary files are incorrectly
  ignored in GIT.

\code{check_hugo()} checks possible problems with the Hugo
  installation and version.

\code{check_netlify()} checks the Hugo version specification and the
  publish directory in the Netlify config file \file{netlify.toml}.
  Specifically, it will check if the local Hugo version matches the version
  specified in \file{netlify.toml} (in the environment variable
  \var{HUGO_VERSION}), and if the \var{publish} setting in
  \file{netlify.toml} matches the \var{publishDir} setting in Hugo's config
  file (if it is set).

\code{check_content()} checks for possible problems in the content
  files. First, it checks for the validity of YAML metadata of all posts.
  Then it searches for posts with future dates and draft posts, and lists
  them if found (such posts appear in the local preview by default, but will
  be ignored by default when building the site). Then it checks for R
  Markdown posts that have not been rendered, or have output files older than
  the source files, and plain Markdown posts that have \file{.html} output
  files (which they should not have). At last, it detects \file{.html} files
  that seem to be generated by clicking the Knit button in RStudio with
  \pkg{blogdown} < v0.21. Such \file{.html} files should be deleted, since
  the Knit button only works with \pkg{blogdown} >= v0.21.
}
