% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-plots-data.R
\name{blr_prep_kschart_data}
\alias{blr_prep_kschart_data}
\alias{blr_prep_kschart_line}
\alias{blr_prep_ksannotate_y}
\alias{blr_prep_kschart_stat}
\alias{blr_prep_ksannotate_x}
\title{KS Chart data}
\usage{
blr_prep_kschart_data(gains_table)

blr_prep_kschart_line(gains_table)

blr_prep_ksannotate_y(ks_line)

blr_prep_kschart_stat(ks_line)

blr_prep_ksannotate_x(ks_line)
}
\arguments{
\item{gains_table}{An object of clas \code{blr_gains_table}.}

\item{ks_line}{Overall conversion rate.}
}
\description{
Data for generating KS chart.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
             family = binomial(link = 'logit'))
gt <- blr_gains_table(model)
blr_prep_kschart_data(gt)
ks_line <- blr_prep_kschart_line(gt)
blr_prep_kschart_stat(ks_line)
blr_prep_ksannotate_y(ks_line)
blr_prep_ksannotate_x(ks_line)

}
