% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/multiplot.R
\name{multiplot}
\alias{multiplot}
\title{Plot multiple ggplot objects.}
\usage{
multiplot(..., plotlist = NULL, cols = 1, layout = NULL)
}
\arguments{
\item{...}{ggplot objects}

\item{plotlist}{a list of ggplot objets}

\item{cols}{number of columns in layout}

\item{layout}{a matrix specifying the layout. If present, 'cols' is ignored.}
}
\description{
Plot multiple ggplot objects on one layer.
}
\details{
If the layout is something like \code{matrix(c(1,2,3,3), nrow=2, byrow=TRUE)},
then plot 1 will go in the upper left, 2 will go in the upper right, and
3 will go all the way across the bottom.
Taken from: http://www.cookbook-r.com/Graphs/Multiple_graphs_on_one_page_(ggplot2)/
}
\examples{
library(ggplot2)
# This example uses the ChickWeight dataset, which comes with ggplot2
p1 <- ggplot(ChickWeight, aes(x=Time, y=weight, colour=Diet, group=Chick)) +
  geom_line() +
  ggtitle("Growth curve for individual chicks")

# Second plot
p2 <- ggplot(ChickWeight, aes(x=Time, y=weight, colour=Diet)) +
  geom_point(alpha=.3) +
  geom_smooth(alpha=.2, size=1) +
  ggtitle("Fitted growth curve per diet")

# Third plot
p3 <- ggplot(subset(ChickWeight, Time==21), aes(x=weight, colour=Diet)) +
  geom_density() +
  ggtitle("Final weight, by diet")

# Fourth plot
p4 <- ggplot(subset(ChickWeight, Time==21), aes(x=weight, fill=Diet)) +
  geom_histogram(colour="black", binwidth=50) +
  facet_grid(Diet ~ .) +
  ggtitle("Final weight, by diet") +
  theme(legend.position="none")  # No legend (redundant in this graph)

multiplot(p1, p2, p3, p4, cols=2)
}

