// Generated by rstantools.  Do not edit by hand.

/*
    bmgarch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bmgarch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bmgarch.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_forecastBEKK_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_forecastBEKK");
    reader.add_event(1, 1, "include", "/functions/cov2cor.stan");
    reader.add_event(1, 0, "start", "/functions/cov2cor.stan");
    reader.add_event(9, 8, "end", "/functions/cov2cor.stan");
    reader.add_event(9, 2, "restart", "model_forecastBEKK");
    reader.add_event(12, 5, "include", "/data/gq_data.stan");
    reader.add_event(12, 0, "start", "/data/gq_data.stan");
    reader.add_event(24, 12, "end", "/data/gq_data.stan");
    reader.add_event(24, 6, "restart", "model_forecastBEKK");
    reader.add_event(28, 10, "include", "/transformed_data/xh_marker.stan");
    reader.add_event(28, 0, "start", "/transformed_data/xh_marker.stan");
    reader.add_event(40, 12, "end", "/transformed_data/xh_marker.stan");
    reader.add_event(40, 11, "restart", "model_forecastBEKK");
    reader.add_event(52, 23, "include", "/parameters/arma.stan");
    reader.add_event(52, 0, "start", "/parameters/arma.stan");
    reader.add_event(59, 7, "end", "/parameters/arma.stan");
    reader.add_event(59, 24, "restart", "model_forecastBEKK");
    reader.add_event(153, 118, "include", "/generated/forecast_sampling.stan");
    reader.add_event(153, 0, "start", "/generated/forecast_sampling.stan");
    reader.add_event(158, 5, "end", "/generated/forecast_sampling.stan");
    reader.add_event(158, 119, "restart", "model_forecastBEKK");
    reader.add_event(178, 139, "include", "/generated/forecast_log_lik.stan");
    reader.add_event(178, 0, "start", "/generated/forecast_log_lik.stan");
    reader.add_event(189, 11, "end", "/generated/forecast_log_lik.stan");
    reader.add_event(189, 140, "restart", "model_forecastBEKK");
    reader.add_event(192, 141, "end", "model_forecastBEKK");
    return reader;
}
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
cov2cor(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& C, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 3;
        int dm(0);
        (void) dm;  // dummy to suppress unused var warning
        stan::math::fill(dm, std::numeric_limits<int>::min());
        stan::math::assign(dm,rows(C));
        current_statement_begin__ = 4;
        validate_non_negative_index("s", "dm", dm);
        validate_non_negative_index("s", "dm", dm);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> s(dm, dm);
        stan::math::initialize(s, DUMMY_VAR__);
        stan::math::fill(s, DUMMY_VAR__);
        current_statement_begin__ = 5;
        validate_non_negative_index("R", "dm", dm);
        validate_non_negative_index("R", "dm", dm);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> R(dm, dm);
        stan::math::initialize(R, DUMMY_VAR__);
        stan::math::fill(R, DUMMY_VAR__);
        current_statement_begin__ = 6;
        stan::math::assign(s, diag_matrix(elt_divide(1.0, stan::math::sqrt(diagonal(C)))));
        current_statement_begin__ = 7;
        stan::math::assign(R, multiply(multiply(s, C), s));
        current_statement_begin__ = 8;
        return stan::math::promote_scalar<fun_return_scalar_t__>(R);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct cov2cor_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& C, std::ostream* pstream__) const {
        return cov2cor(C, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_forecastBEKK
  : public stan::model::model_base_crtp<model_forecastBEKK> {
private:
        int T;
        int nt;
        int Q;
        int P;
        std::vector<vector_d> rts;
        std::vector<vector_d> xC;
        int distribution;
        int meanstructure;
        int ahead;
        std::vector<vector_d> xC_p;
        std::vector<vector_d> future_rts;
        int compute_log_lik;
        matrix_d xC_c;
        std::vector<matrix_d> xC_m;
        int xC_marker;
        double cp;
public:
    model_forecastBEKK(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_forecastBEKK(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_forecastBEKK_namespace::model_forecastBEKK";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 13;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            check_greater_or_equal(function__, "T", T, 2);
            current_statement_begin__ = 14;
            context__.validate_dims("data initialization", "nt", "int", context__.to_vec());
            nt = int(0);
            vals_i__ = context__.vals_i("nt");
            pos__ = 0;
            nt = vals_i__[pos__++];
            check_greater_or_equal(function__, "nt", nt, 2);
            current_statement_begin__ = 15;
            context__.validate_dims("data initialization", "Q", "int", context__.to_vec());
            Q = int(0);
            vals_i__ = context__.vals_i("Q");
            pos__ = 0;
            Q = vals_i__[pos__++];
            check_greater_or_equal(function__, "Q", Q, 1);
            current_statement_begin__ = 16;
            context__.validate_dims("data initialization", "P", "int", context__.to_vec());
            P = int(0);
            vals_i__ = context__.vals_i("P");
            pos__ = 0;
            P = vals_i__[pos__++];
            check_greater_or_equal(function__, "P", P, 1);
            current_statement_begin__ = 17;
            validate_non_negative_index("rts", "nt", nt);
            validate_non_negative_index("rts", "T", T);
            context__.validate_dims("data initialization", "rts", "vector_d", context__.to_vec(T,nt));
            rts = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            vals_r__ = context__.vals_r("rts");
            pos__ = 0;
            size_t rts_j_1_max__ = nt;
            size_t rts_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < rts_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rts_k_0_max__; ++k_0__) {
                    rts[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 18;
            validate_non_negative_index("xC", "nt", nt);
            validate_non_negative_index("xC", "T", T);
            context__.validate_dims("data initialization", "xC", "vector_d", context__.to_vec(T,nt));
            xC = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            vals_r__ = context__.vals_r("xC");
            pos__ = 0;
            size_t xC_j_1_max__ = nt;
            size_t xC_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < xC_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < xC_k_0_max__; ++k_0__) {
                    xC[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 19;
            context__.validate_dims("data initialization", "distribution", "int", context__.to_vec());
            distribution = int(0);
            vals_i__ = context__.vals_i("distribution");
            pos__ = 0;
            distribution = vals_i__[pos__++];
            check_greater_or_equal(function__, "distribution", distribution, 0);
            check_less_or_equal(function__, "distribution", distribution, 1);
            current_statement_begin__ = 20;
            context__.validate_dims("data initialization", "meanstructure", "int", context__.to_vec());
            meanstructure = int(0);
            vals_i__ = context__.vals_i("meanstructure");
            pos__ = 0;
            meanstructure = vals_i__[pos__++];
            check_greater_or_equal(function__, "meanstructure", meanstructure, 0);
            check_less_or_equal(function__, "meanstructure", meanstructure, 2);
            current_statement_begin__ = 21;
            context__.validate_dims("data initialization", "ahead", "int", context__.to_vec());
            ahead = int(0);
            vals_i__ = context__.vals_i("ahead");
            pos__ = 0;
            ahead = vals_i__[pos__++];
            check_greater_or_equal(function__, "ahead", ahead, 1);
            current_statement_begin__ = 22;
            validate_non_negative_index("xC_p", "nt", nt);
            validate_non_negative_index("xC_p", "ahead", ahead);
            context__.validate_dims("data initialization", "xC_p", "vector_d", context__.to_vec(ahead,nt));
            xC_p = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(ahead, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            vals_r__ = context__.vals_r("xC_p");
            pos__ = 0;
            size_t xC_p_j_1_max__ = nt;
            size_t xC_p_k_0_max__ = ahead;
            for (size_t j_1__ = 0; j_1__ < xC_p_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < xC_p_k_0_max__; ++k_0__) {
                    xC_p[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 23;
            validate_non_negative_index("future_rts", "nt", nt);
            validate_non_negative_index("future_rts", "ahead", ahead);
            context__.validate_dims("data initialization", "future_rts", "vector_d", context__.to_vec(ahead,nt));
            future_rts = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(ahead, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            vals_r__ = context__.vals_r("future_rts");
            pos__ = 0;
            size_t future_rts_j_1_max__ = nt;
            size_t future_rts_k_0_max__ = ahead;
            for (size_t j_1__ = 0; j_1__ < future_rts_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < future_rts_k_0_max__; ++k_0__) {
                    future_rts[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 24;
            context__.validate_dims("data initialization", "compute_log_lik", "int", context__.to_vec());
            compute_log_lik = int(0);
            vals_i__ = context__.vals_i("compute_log_lik");
            pos__ = 0;
            compute_log_lik = vals_i__[pos__++];
            check_greater_or_equal(function__, "compute_log_lik", compute_log_lik, 0);
            check_less_or_equal(function__, "compute_log_lik", compute_log_lik, 1);
            // initialize transformed data variables
            current_statement_begin__ = 28;
            validate_non_negative_index("xC_c", "(ahead + std::max(Q, P))", (ahead + std::max(Q, P)));
            validate_non_negative_index("xC_c", "nt", nt);
            xC_c = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((ahead + std::max(Q, P)), nt);
            stan::math::fill(xC_c, DUMMY_VAR__);
            current_statement_begin__ = 30;
            validate_non_negative_index("xC_m", "nt", nt);
            validate_non_negative_index("xC_m", "nt", nt);
            validate_non_negative_index("xC_m", "T", T);
            xC_m = std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> >(T, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::fill(xC_m, DUMMY_VAR__);
            current_statement_begin__ = 31;
            xC_marker = int(0);
            stan::math::fill(xC_marker, std::numeric_limits<int>::min());
            stan::math::assign(xC_marker,0);
            current_statement_begin__ = 32;
            cp = double(0);
            stan::math::fill(cp, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 34;
            for (int t = 1; t <= T; ++t) {
                current_statement_begin__ = 35;
                stan::model::assign(xC_m, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            diag_matrix(get_base1(xC, t, "xC", 1)), 
                            "assigning variable xC_m");
                current_statement_begin__ = 37;
                stan::math::assign(cp, sum(multiply(transpose(get_base1(xC_m, t, "xC_m", 1)), get_base1(xC_m, t, "xC_m", 1))));
                current_statement_begin__ = 38;
                if (as_bool(logical_neq(cp, 0))) {
                    current_statement_begin__ = 39;
                    stan::math::assign(xC_marker, (xC_marker + 1));
                }
            }
            current_statement_begin__ = 42;
            for (int i = 1; i <= std::max(Q, P); ++i) {
                current_statement_begin__ = 43;
                stan::model::assign(xC_c, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            transpose(get_base1(xC, (T - (std::max(Q, P) - 1)), "xC", 1)), 
                            "assigning variable xC_c");
            }
            current_statement_begin__ = 45;
            for (int i = 1; i <= ahead; ++i) {
                current_statement_begin__ = 46;
                stan::model::assign(xC_c, 
                            stan::model::cons_list(stan::model::index_uni((i + std::max(Q, P))), stan::model::nil_index_list()), 
                            transpose(get_base1(xC_p, i, "xC_p", 1)), 
                            "assigning variable xC_c");
            }
            // validate transformed data
            current_statement_begin__ = 31;
            check_greater_or_equal(function__, "xC_marker", xC_marker, 0);
            current_statement_begin__ = 32;
            check_greater_or_equal(function__, "cp", cp, 0);
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 53;
            validate_non_negative_index("phi0", "nt", nt);
            num_params_r__ += nt;
            current_statement_begin__ = 58;
            validate_non_negative_index("phi", "nt", nt);
            validate_non_negative_index("phi", "nt", nt);
            num_params_r__ += (nt * nt);
            current_statement_begin__ = 59;
            validate_non_negative_index("theta", "nt", nt);
            validate_non_negative_index("theta", "nt", nt);
            num_params_r__ += (nt * nt);
            current_statement_begin__ = 64;
            validate_non_negative_index("beta0", "nt", nt);
            num_params_r__ += nt;
            current_statement_begin__ = 65;
            validate_non_negative_index("beta1", "nt", nt);
            num_params_r__ += nt;
            current_statement_begin__ = 68;
            validate_non_negative_index("C_R", "nt", nt);
            validate_non_negative_index("C_R", "nt", nt);
            num_params_r__ += ((nt * (nt - 1)) / 2);
            current_statement_begin__ = 71;
            num_params_r__ += 1;
            current_statement_begin__ = 74;
            validate_non_negative_index("Cnst", "nt", nt);
            validate_non_negative_index("Cnst", "nt", nt);
            num_params_r__ += (nt + ((nt * (nt - 1)) / 2));
            current_statement_begin__ = 76;
            validate_non_negative_index("H", "nt", nt);
            validate_non_negative_index("H", "nt", nt);
            validate_non_negative_index("H", "T", T);
            num_params_r__ += ((nt + ((nt * (nt - 1)) / 2)) * T);
            current_statement_begin__ = 77;
            validate_non_negative_index("rr", "nt", nt);
            validate_non_negative_index("rr", "nt", nt);
            validate_non_negative_index("rr", "(T - 1)", (T - 1));
            num_params_r__ += ((nt * nt) * (T - 1));
            current_statement_begin__ = 78;
            validate_non_negative_index("mu", "nt", nt);
            validate_non_negative_index("mu", "T", T);
            num_params_r__ += (nt * T);
            current_statement_begin__ = 79;
            validate_non_negative_index("A", "nt", nt);
            validate_non_negative_index("A", "nt", nt);
            validate_non_negative_index("A", "Q", Q);
            num_params_r__ += ((nt * nt) * Q);
            current_statement_begin__ = 80;
            validate_non_negative_index("B", "nt", nt);
            validate_non_negative_index("B", "nt", nt);
            validate_non_negative_index("B", "P", P);
            num_params_r__ += ((nt * nt) * P);
            current_statement_begin__ = 81;
            validate_non_negative_index("corH", "nt", nt);
            validate_non_negative_index("corH", "nt", nt);
            validate_non_negative_index("corH", "T", T);
            num_params_r__ += (((nt * (nt - 1)) / 2) * T);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_forecastBEKK() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 53;
        if (!(context__.contains_r("phi0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi0");
        pos__ = 0U;
        validate_non_negative_index("phi0", "nt", nt);
        context__.validate_dims("parameter initialization", "phi0", "vector_d", context__.to_vec(nt));
        Eigen::Matrix<double, Eigen::Dynamic, 1> phi0(nt);
        size_t phi0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < phi0_j_1_max__; ++j_1__) {
            phi0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(phi0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 58;
        if (!(context__.contains_r("phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        validate_non_negative_index("phi", "nt", nt);
        validate_non_negative_index("phi", "nt", nt);
        context__.validate_dims("parameter initialization", "phi", "matrix_d", context__.to_vec(nt,nt));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> phi(nt, nt);
        size_t phi_j_2_max__ = nt;
        size_t phi_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < phi_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                phi(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_lub_unconstrain(-(1), 1, phi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 59;
        if (!(context__.contains_r("theta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta");
        pos__ = 0U;
        validate_non_negative_index("theta", "nt", nt);
        validate_non_negative_index("theta", "nt", nt);
        context__.validate_dims("parameter initialization", "theta", "matrix_d", context__.to_vec(nt,nt));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> theta(nt, nt);
        size_t theta_j_2_max__ = nt;
        size_t theta_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                theta(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_lub_unconstrain(-(1), 1, theta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 64;
        if (!(context__.contains_r("beta0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta0");
        pos__ = 0U;
        validate_non_negative_index("beta0", "nt", nt);
        context__.validate_dims("parameter initialization", "beta0", "row_vector_d", context__.to_vec(nt));
        Eigen::Matrix<double, 1, Eigen::Dynamic> beta0(nt);
        size_t beta0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta0_j_1_max__; ++j_1__) {
            beta0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.row_vector_unconstrain(beta0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 65;
        if (!(context__.contains_r("beta1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta1");
        pos__ = 0U;
        validate_non_negative_index("beta1", "nt", nt);
        context__.validate_dims("parameter initialization", "beta1", "vector_d", context__.to_vec(nt));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta1(nt);
        size_t beta1_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta1_j_1_max__; ++j_1__) {
            beta1(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 68;
        if (!(context__.contains_r("C_R")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable C_R missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("C_R");
        pos__ = 0U;
        validate_non_negative_index("C_R", "nt", nt);
        validate_non_negative_index("C_R", "nt", nt);
        context__.validate_dims("parameter initialization", "C_R", "matrix_d", context__.to_vec(nt,nt));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> C_R(nt, nt);
        size_t C_R_j_2_max__ = nt;
        size_t C_R_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < C_R_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < C_R_j_1_max__; ++j_1__) {
                C_R(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.corr_matrix_unconstrain(C_R);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable C_R: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 71;
        if (!(context__.contains_r("nu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nu");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "nu", "double", context__.to_vec());
        double nu(0);
        nu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(2, nu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 74;
        if (!(context__.contains_r("Cnst")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable Cnst missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("Cnst");
        pos__ = 0U;
        validate_non_negative_index("Cnst", "nt", nt);
        validate_non_negative_index("Cnst", "nt", nt);
        context__.validate_dims("parameter initialization", "Cnst", "matrix_d", context__.to_vec(nt,nt));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Cnst(nt, nt);
        size_t Cnst_j_2_max__ = nt;
        size_t Cnst_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < Cnst_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Cnst_j_1_max__; ++j_1__) {
                Cnst(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.cov_matrix_unconstrain(Cnst);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable Cnst: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 76;
        if (!(context__.contains_r("H")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable H missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("H");
        pos__ = 0U;
        validate_non_negative_index("H", "nt", nt);
        validate_non_negative_index("H", "nt", nt);
        validate_non_negative_index("H", "T", T);
        context__.validate_dims("parameter initialization", "H", "matrix_d", context__.to_vec(T,nt,nt));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > H(T, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
        size_t H_j_2_max__ = nt;
        size_t H_j_1_max__ = nt;
        size_t H_k_0_max__ = T;
        for (size_t j_2__ = 0; j_2__ < H_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < H_k_0_max__; ++k_0__) {
                    H[k_0__](j_1__, j_2__) = vals_r__[pos__++];
                }
            }
        }
        size_t H_i_0_max__ = T;
        for (size_t i_0__ = 0; i_0__ < H_i_0_max__; ++i_0__) {
            try {
                writer__.cov_matrix_unconstrain(H[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable H: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 77;
        if (!(context__.contains_r("rr")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rr missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rr");
        pos__ = 0U;
        validate_non_negative_index("rr", "nt", nt);
        validate_non_negative_index("rr", "nt", nt);
        validate_non_negative_index("rr", "(T - 1)", (T - 1));
        context__.validate_dims("parameter initialization", "rr", "matrix_d", context__.to_vec((T - 1),nt,nt));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > rr((T - 1), Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
        size_t rr_j_2_max__ = nt;
        size_t rr_j_1_max__ = nt;
        size_t rr_k_0_max__ = (T - 1);
        for (size_t j_2__ = 0; j_2__ < rr_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rr_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                    rr[k_0__](j_1__, j_2__) = vals_r__[pos__++];
                }
            }
        }
        size_t rr_i_0_max__ = (T - 1);
        for (size_t i_0__ = 0; i_0__ < rr_i_0_max__; ++i_0__) {
            try {
                writer__.matrix_unconstrain(rr[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rr: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 78;
        if (!(context__.contains_r("mu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        validate_non_negative_index("mu", "nt", nt);
        validate_non_negative_index("mu", "T", T);
        context__.validate_dims("parameter initialization", "mu", "vector_d", context__.to_vec(T,nt));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > mu(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
        size_t mu_j_1_max__ = nt;
        size_t mu_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                mu[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t mu_i_0_max__ = T;
        for (size_t i_0__ = 0; i_0__ < mu_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(mu[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 79;
        if (!(context__.contains_r("A")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable A missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("A");
        pos__ = 0U;
        validate_non_negative_index("A", "nt", nt);
        validate_non_negative_index("A", "nt", nt);
        validate_non_negative_index("A", "Q", Q);
        context__.validate_dims("parameter initialization", "A", "matrix_d", context__.to_vec(Q,nt,nt));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > A(Q, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
        size_t A_j_2_max__ = nt;
        size_t A_j_1_max__ = nt;
        size_t A_k_0_max__ = Q;
        for (size_t j_2__ = 0; j_2__ < A_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < A_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < A_k_0_max__; ++k_0__) {
                    A[k_0__](j_1__, j_2__) = vals_r__[pos__++];
                }
            }
        }
        size_t A_i_0_max__ = Q;
        for (size_t i_0__ = 0; i_0__ < A_i_0_max__; ++i_0__) {
            try {
                writer__.matrix_unconstrain(A[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable A: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 80;
        if (!(context__.contains_r("B")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable B missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("B");
        pos__ = 0U;
        validate_non_negative_index("B", "nt", nt);
        validate_non_negative_index("B", "nt", nt);
        validate_non_negative_index("B", "P", P);
        context__.validate_dims("parameter initialization", "B", "matrix_d", context__.to_vec(P,nt,nt));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > B(P, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
        size_t B_j_2_max__ = nt;
        size_t B_j_1_max__ = nt;
        size_t B_k_0_max__ = P;
        for (size_t j_2__ = 0; j_2__ < B_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < B_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < B_k_0_max__; ++k_0__) {
                    B[k_0__](j_1__, j_2__) = vals_r__[pos__++];
                }
            }
        }
        size_t B_i_0_max__ = P;
        for (size_t i_0__ = 0; i_0__ < B_i_0_max__; ++i_0__) {
            try {
                writer__.matrix_unconstrain(B[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable B: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 81;
        if (!(context__.contains_r("corH")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable corH missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("corH");
        pos__ = 0U;
        validate_non_negative_index("corH", "nt", nt);
        validate_non_negative_index("corH", "nt", nt);
        validate_non_negative_index("corH", "T", T);
        context__.validate_dims("parameter initialization", "corH", "matrix_d", context__.to_vec(T,nt,nt));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > corH(T, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
        size_t corH_j_2_max__ = nt;
        size_t corH_j_1_max__ = nt;
        size_t corH_k_0_max__ = T;
        for (size_t j_2__ = 0; j_2__ < corH_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < corH_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < corH_k_0_max__; ++k_0__) {
                    corH[k_0__](j_1__, j_2__) = vals_r__[pos__++];
                }
            }
        }
        size_t corH_i_0_max__ = T;
        for (size_t i_0__ = 0; i_0__ < corH_i_0_max__; ++i_0__) {
            try {
                writer__.corr_matrix_unconstrain(corH[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable corH: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 53;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> phi0;
            (void) phi0;  // dummy to suppress unused var warning
            if (jacobian__)
                phi0 = in__.vector_constrain(nt, lp__);
            else
                phi0 = in__.vector_constrain(nt);
            current_statement_begin__ = 58;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> phi;
            (void) phi;  // dummy to suppress unused var warning
            if (jacobian__)
                phi = in__.matrix_lub_constrain(-(1), 1, nt, nt, lp__);
            else
                phi = in__.matrix_lub_constrain(-(1), 1, nt, nt);
            current_statement_begin__ = 59;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> theta;
            (void) theta;  // dummy to suppress unused var warning
            if (jacobian__)
                theta = in__.matrix_lub_constrain(-(1), 1, nt, nt, lp__);
            else
                theta = in__.matrix_lub_constrain(-(1), 1, nt, nt);
            current_statement_begin__ = 64;
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> beta0;
            (void) beta0;  // dummy to suppress unused var warning
            if (jacobian__)
                beta0 = in__.row_vector_constrain(nt, lp__);
            else
                beta0 = in__.row_vector_constrain(nt);
            current_statement_begin__ = 65;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta1;
            (void) beta1;  // dummy to suppress unused var warning
            if (jacobian__)
                beta1 = in__.vector_constrain(nt, lp__);
            else
                beta1 = in__.vector_constrain(nt);
            current_statement_begin__ = 68;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> C_R;
            (void) C_R;  // dummy to suppress unused var warning
            if (jacobian__)
                C_R = in__.corr_matrix_constrain(nt, lp__);
            else
                C_R = in__.corr_matrix_constrain(nt);
            current_statement_begin__ = 71;
            local_scalar_t__ nu;
            (void) nu;  // dummy to suppress unused var warning
            if (jacobian__)
                nu = in__.scalar_lb_constrain(2, lp__);
            else
                nu = in__.scalar_lb_constrain(2);
            current_statement_begin__ = 74;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Cnst;
            (void) Cnst;  // dummy to suppress unused var warning
            if (jacobian__)
                Cnst = in__.cov_matrix_constrain(nt, lp__);
            else
                Cnst = in__.cov_matrix_constrain(nt);
            current_statement_begin__ = 76;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > H;
            size_t H_d_0_max__ = T;
            H.reserve(H_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < H_d_0_max__; ++d_0__) {
                if (jacobian__)
                    H.push_back(in__.cov_matrix_constrain(nt, lp__));
                else
                    H.push_back(in__.cov_matrix_constrain(nt));
            }
            current_statement_begin__ = 77;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > rr;
            size_t rr_d_0_max__ = (T - 1);
            rr.reserve(rr_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < rr_d_0_max__; ++d_0__) {
                if (jacobian__)
                    rr.push_back(in__.matrix_constrain(nt, nt, lp__));
                else
                    rr.push_back(in__.matrix_constrain(nt, nt));
            }
            current_statement_begin__ = 78;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > mu;
            size_t mu_d_0_max__ = T;
            mu.reserve(mu_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < mu_d_0_max__; ++d_0__) {
                if (jacobian__)
                    mu.push_back(in__.vector_constrain(nt, lp__));
                else
                    mu.push_back(in__.vector_constrain(nt));
            }
            current_statement_begin__ = 79;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > A;
            size_t A_d_0_max__ = Q;
            A.reserve(A_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < A_d_0_max__; ++d_0__) {
                if (jacobian__)
                    A.push_back(in__.matrix_constrain(nt, nt, lp__));
                else
                    A.push_back(in__.matrix_constrain(nt, nt));
            }
            current_statement_begin__ = 80;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > B;
            size_t B_d_0_max__ = P;
            B.reserve(B_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < B_d_0_max__; ++d_0__) {
                if (jacobian__)
                    B.push_back(in__.matrix_constrain(nt, nt, lp__));
                else
                    B.push_back(in__.matrix_constrain(nt, nt));
            }
            current_statement_begin__ = 81;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > corH;
            size_t corH_d_0_max__ = T;
            corH.reserve(corH_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < corH_d_0_max__; ++d_0__) {
                if (jacobian__)
                    corH.push_back(in__.corr_matrix_constrain(nt, lp__));
                else
                    corH.push_back(in__.corr_matrix_constrain(nt));
            }
            // model body
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("phi0");
        names__.push_back("phi");
        names__.push_back("theta");
        names__.push_back("beta0");
        names__.push_back("beta1");
        names__.push_back("C_R");
        names__.push_back("nu");
        names__.push_back("Cnst");
        names__.push_back("H");
        names__.push_back("rr");
        names__.push_back("mu");
        names__.push_back("A");
        names__.push_back("B");
        names__.push_back("corH");
        names__.push_back("rts_p");
        names__.push_back("rts_forecasted");
        names__.push_back("H_p");
        names__.push_back("R_p");
        names__.push_back("H_forecasted");
        names__.push_back("R_forecasted");
        names__.push_back("rr_p");
        names__.push_back("mu_p");
        names__.push_back("mu_forecasted");
        names__.push_back("beta");
        names__.push_back("log_lik");
        names__.push_back("A_part_p");
        names__.push_back("B_part_p");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((T - 1));
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Q);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((ahead + std::max(Q, P)));
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ahead);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((ahead + std::max(Q, P)));
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((ahead + std::max(Q, P)));
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ahead);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ahead);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((ahead + std::max(Q, P)));
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((ahead + std::max(Q, P)));
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ahead);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nt + 1));
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(compute_log_lik, 1) ? ahead : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_forecastBEKK_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> phi0 = in__.vector_constrain(nt);
        size_t phi0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < phi0_j_1_max__; ++j_1__) {
            vars__.push_back(phi0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> phi = in__.matrix_lub_constrain(-(1), 1, nt, nt);
        size_t phi_j_2_max__ = nt;
        size_t phi_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < phi_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                vars__.push_back(phi(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> theta = in__.matrix_lub_constrain(-(1), 1, nt, nt);
        size_t theta_j_2_max__ = nt;
        size_t theta_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                vars__.push_back(theta(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, 1, Eigen::Dynamic> beta0 = in__.row_vector_constrain(nt);
        size_t beta0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta0_j_1_max__; ++j_1__) {
            vars__.push_back(beta0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta1 = in__.vector_constrain(nt);
        size_t beta1_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta1_j_1_max__; ++j_1__) {
            vars__.push_back(beta1(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> C_R = in__.corr_matrix_constrain(nt);
        size_t C_R_j_2_max__ = nt;
        size_t C_R_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < C_R_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < C_R_j_1_max__; ++j_1__) {
                vars__.push_back(C_R(j_1__, j_2__));
            }
        }
        double nu = in__.scalar_lb_constrain(2);
        vars__.push_back(nu);
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Cnst = in__.cov_matrix_constrain(nt);
        size_t Cnst_j_2_max__ = nt;
        size_t Cnst_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < Cnst_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Cnst_j_1_max__; ++j_1__) {
                vars__.push_back(Cnst(j_1__, j_2__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > H;
        size_t H_d_0_max__ = T;
        H.reserve(H_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < H_d_0_max__; ++d_0__) {
            H.push_back(in__.cov_matrix_constrain(nt));
        }
        size_t H_j_2_max__ = nt;
        size_t H_j_1_max__ = nt;
        size_t H_k_0_max__ = T;
        for (size_t j_2__ = 0; j_2__ < H_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < H_k_0_max__; ++k_0__) {
                    vars__.push_back(H[k_0__](j_1__, j_2__));
                }
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > rr;
        size_t rr_d_0_max__ = (T - 1);
        rr.reserve(rr_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < rr_d_0_max__; ++d_0__) {
            rr.push_back(in__.matrix_constrain(nt, nt));
        }
        size_t rr_j_2_max__ = nt;
        size_t rr_j_1_max__ = nt;
        size_t rr_k_0_max__ = (T - 1);
        for (size_t j_2__ = 0; j_2__ < rr_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rr_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                    vars__.push_back(rr[k_0__](j_1__, j_2__));
                }
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > mu;
        size_t mu_d_0_max__ = T;
        mu.reserve(mu_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < mu_d_0_max__; ++d_0__) {
            mu.push_back(in__.vector_constrain(nt));
        }
        size_t mu_j_1_max__ = nt;
        size_t mu_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                vars__.push_back(mu[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > A;
        size_t A_d_0_max__ = Q;
        A.reserve(A_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < A_d_0_max__; ++d_0__) {
            A.push_back(in__.matrix_constrain(nt, nt));
        }
        size_t A_j_2_max__ = nt;
        size_t A_j_1_max__ = nt;
        size_t A_k_0_max__ = Q;
        for (size_t j_2__ = 0; j_2__ < A_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < A_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < A_k_0_max__; ++k_0__) {
                    vars__.push_back(A[k_0__](j_1__, j_2__));
                }
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > B;
        size_t B_d_0_max__ = P;
        B.reserve(B_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < B_d_0_max__; ++d_0__) {
            B.push_back(in__.matrix_constrain(nt, nt));
        }
        size_t B_j_2_max__ = nt;
        size_t B_j_1_max__ = nt;
        size_t B_k_0_max__ = P;
        for (size_t j_2__ = 0; j_2__ < B_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < B_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < B_k_0_max__; ++k_0__) {
                    vars__.push_back(B[k_0__](j_1__, j_2__));
                }
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > corH;
        size_t corH_d_0_max__ = T;
        corH.reserve(corH_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < corH_d_0_max__; ++d_0__) {
            corH.push_back(in__.corr_matrix_constrain(nt));
        }
        size_t corH_j_2_max__ = nt;
        size_t corH_j_1_max__ = nt;
        size_t corH_k_0_max__ = T;
        for (size_t j_2__ = 0; j_2__ < corH_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < corH_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < corH_k_0_max__; ++k_0__) {
                    vars__.push_back(corH[k_0__](j_1__, j_2__));
                }
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 86;
            validate_non_negative_index("rts_p", "nt", nt);
            validate_non_negative_index("rts_p", "(ahead + std::max(Q, P))", (ahead + std::max(Q, P)));
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > rts_p((ahead + std::max(Q, P)), Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(rts_p, DUMMY_VAR__);
            stan::math::fill(rts_p, DUMMY_VAR__);
            current_statement_begin__ = 87;
            validate_non_negative_index("rts_forecasted", "nt", nt);
            validate_non_negative_index("rts_forecasted", "ahead", ahead);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > rts_forecasted(ahead, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(rts_forecasted, DUMMY_VAR__);
            stan::math::fill(rts_forecasted, DUMMY_VAR__);
            current_statement_begin__ = 89;
            validate_non_negative_index("H_p", "nt", nt);
            validate_non_negative_index("H_p", "nt", nt);
            validate_non_negative_index("H_p", "(ahead + std::max(Q, P))", (ahead + std::max(Q, P)));
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > H_p((ahead + std::max(Q, P)), Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(H_p, DUMMY_VAR__);
            stan::math::fill(H_p, DUMMY_VAR__);
            current_statement_begin__ = 90;
            validate_non_negative_index("R_p", "nt", nt);
            validate_non_negative_index("R_p", "nt", nt);
            validate_non_negative_index("R_p", "(ahead + std::max(Q, P))", (ahead + std::max(Q, P)));
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > R_p((ahead + std::max(Q, P)), Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(R_p, DUMMY_VAR__);
            stan::math::fill(R_p, DUMMY_VAR__);
            current_statement_begin__ = 91;
            validate_non_negative_index("H_forecasted", "nt", nt);
            validate_non_negative_index("H_forecasted", "nt", nt);
            validate_non_negative_index("H_forecasted", "ahead", ahead);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > H_forecasted(ahead, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(H_forecasted, DUMMY_VAR__);
            stan::math::fill(H_forecasted, DUMMY_VAR__);
            current_statement_begin__ = 92;
            validate_non_negative_index("R_forecasted", "nt", nt);
            validate_non_negative_index("R_forecasted", "nt", nt);
            validate_non_negative_index("R_forecasted", "ahead", ahead);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > R_forecasted(ahead, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(R_forecasted, DUMMY_VAR__);
            stan::math::fill(R_forecasted, DUMMY_VAR__);
            current_statement_begin__ = 94;
            validate_non_negative_index("rr_p", "nt", nt);
            validate_non_negative_index("rr_p", "nt", nt);
            validate_non_negative_index("rr_p", "(ahead + std::max(Q, P))", (ahead + std::max(Q, P)));
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > rr_p((ahead + std::max(Q, P)), Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(rr_p, DUMMY_VAR__);
            stan::math::fill(rr_p, DUMMY_VAR__);
            current_statement_begin__ = 95;
            validate_non_negative_index("mu_p", "nt", nt);
            validate_non_negative_index("mu_p", "(ahead + std::max(Q, P))", (ahead + std::max(Q, P)));
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > mu_p((ahead + std::max(Q, P)), Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(mu_p, DUMMY_VAR__);
            stan::math::fill(mu_p, DUMMY_VAR__);
            current_statement_begin__ = 96;
            validate_non_negative_index("mu_forecasted", "nt", nt);
            validate_non_negative_index("mu_forecasted", "ahead", ahead);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > mu_forecasted(ahead, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(mu_forecasted, DUMMY_VAR__);
            stan::math::fill(mu_forecasted, DUMMY_VAR__);
            current_statement_begin__ = 98;
            validate_non_negative_index("beta", "(nt + 1)", (nt + 1));
            validate_non_negative_index("beta", "nt", nt);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta((nt + 1), nt);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            stan::math::assign(beta,append_row(beta0, diag_matrix(beta1)));
            current_statement_begin__ = 102;
            validate_non_negative_index("log_lik", "(logical_eq(compute_log_lik, 1) ? ahead : 0 )", (logical_eq(compute_log_lik, 1) ? ahead : 0 ));
            std::vector<double> log_lik((logical_eq(compute_log_lik, 1) ? ahead : 0 ), double(0));
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 105;
            validate_non_negative_index("A_part_p", "nt", nt);
            validate_non_negative_index("A_part_p", "nt", nt);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> A_part_p(nt, nt);
            stan::math::initialize(A_part_p, DUMMY_VAR__);
            stan::math::fill(A_part_p, DUMMY_VAR__);
            current_statement_begin__ = 106;
            validate_non_negative_index("B_part_p", "nt", nt);
            validate_non_negative_index("B_part_p", "nt", nt);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> B_part_p(nt, nt);
            stan::math::initialize(B_part_p, DUMMY_VAR__);
            stan::math::fill(B_part_p, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 109;
            stan::model::assign(rts_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), 
                        "assigning variable rts_p");
            current_statement_begin__ = 110;
            stan::model::assign(H_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(H, stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H"), 
                        "assigning variable H_p");
            current_statement_begin__ = 111;
            stan::model::assign(mu_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"), 
                        "assigning variable mu_p");
            current_statement_begin__ = 112;
            stan::model::assign(rr_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(rr, stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rr"), 
                        "assigning variable rr_p");
            current_statement_begin__ = 114;
            stan::model::assign(R_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(corH, stan::model::cons_list(stan::model::index_min_max(1, (ahead + std::max(Q, P))), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "corH"), 
                        "assigning variable R_p");
            current_statement_begin__ = 117;
            stan::model::assign(rts_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, std::max(Q, P)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_min_max((T - (std::max(Q, P) - 1)), T), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), 
                        "assigning variable rts_p");
            current_statement_begin__ = 118;
            stan::model::assign(H_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, std::max(Q, P)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(H, stan::model::cons_list(stan::model::index_min_max((T - (std::max(Q, P) - 1)), T), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H"), 
                        "assigning variable H_p");
            current_statement_begin__ = 119;
            stan::model::assign(mu_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, std::max(Q, P)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_min_max((T - (std::max(Q, P) - 1)), T), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"), 
                        "assigning variable mu_p");
            current_statement_begin__ = 121;
            stan::model::assign(rr_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, std::max(Q, P)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(rr, stan::model::cons_list(stan::model::index_min_max(((T - 1) - (std::max(Q, P) - 1)), (T - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rr"), 
                        "assigning variable rr_p");
            current_statement_begin__ = 122;
            stan::model::assign(R_p, 
                        stan::model::cons_list(stan::model::index_min_max(1, std::max(Q, P)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(corH, stan::model::cons_list(stan::model::index_min_max((T - (std::max(Q, P) - 1)), T), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "corH"), 
                        "assigning variable R_p");
            current_statement_begin__ = 126;
            for (int t = (std::max(Q, P) + 1); t <= (std::max(Q, P) + ahead); ++t) {
                current_statement_begin__ = 129;
                stan::math::assign(A_part_p, diag_matrix(rep_vector(0.0, nt)));
                current_statement_begin__ = 130;
                stan::math::assign(B_part_p, diag_matrix(rep_vector(0.0, nt)));
                current_statement_begin__ = 132;
                if (as_bool(logical_eq(meanstructure, 0))) {
                    current_statement_begin__ = 133;
                    stan::model::assign(mu_p, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                phi0, 
                                "assigning variable mu_p");
                } else if (as_bool(logical_eq(meanstructure, 1))) {
                    current_statement_begin__ = 135;
                    stan::model::assign(mu_p, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                stan::model::deep_copy(add(add(phi0, multiply(phi, stan::model::rvalue(rts_p, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts_p"))), multiply(theta, subtract(stan::model::rvalue(rts_p, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts_p"), stan::model::rvalue(mu_p, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu_p"))))), 
                                "assigning variable mu_p");
                }
                current_statement_begin__ = 138;
                for (int q = 1; q <= std::min((t - 1), Q); ++q) {
                    current_statement_begin__ = 139;
                    stan::model::assign(rr_p, 
                                stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                multiply(subtract(stan::model::rvalue(rts_p, stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts_p"), stan::model::rvalue(mu_p, stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu_p")), transpose(subtract(stan::model::rvalue(rts_p, stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts_p"), stan::model::rvalue(mu_p, stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu_p")))), 
                                "assigning variable rr_p");
                    current_statement_begin__ = 140;
                    stan::math::assign(A_part_p, add(A_part_p, multiply(multiply(transpose(get_base1(A, q, "A", 1)), stan::model::rvalue(rr_p, stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rr_p")), get_base1(A, q, "A", 1))));
                }
                current_statement_begin__ = 142;
                for (int p = 1; p <= std::min((t - 1), P); ++p) {
                    current_statement_begin__ = 143;
                    stan::math::assign(B_part_p, add(B_part_p, multiply(multiply(transpose(get_base1(B, p, "B", 1)), stan::model::rvalue(H_p, stan::model::cons_list(stan::model::index_uni((t - p)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H_p")), get_base1(B, p, "B", 1))));
                }
                current_statement_begin__ = 145;
                if (as_bool(logical_eq(xC_marker, 0))) {
                    current_statement_begin__ = 146;
                    stan::model::assign(H_p, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                add(add(quad_form_diag(C_R, stan::math::exp(beta0)), A_part_p), B_part_p), 
                                "assigning variable H_p");
                } else if (as_bool(logical_gte(xC_marker, 1))) {
                    current_statement_begin__ = 148;
                    stan::model::assign(H_p, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                add(add(quad_form_diag(C_R, stan::math::exp(multiply(append_col(1.0, stan::model::rvalue(xC_c, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "xC_c")), beta))), A_part_p), B_part_p), 
                                "assigning variable H_p");
                }
                current_statement_begin__ = 151;
                stan::model::assign(R_p, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                            cov2cor(stan::model::rvalue(H_p, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H_p"), pstream__), 
                            "assigning variable R_p");
                current_statement_begin__ = 154;
                if (as_bool(logical_eq(distribution, 0))) {
                    current_statement_begin__ = 155;
                    stan::model::assign(rts_p, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                multi_normal_rng(stan::model::rvalue(mu_p, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu_p"), stan::model::rvalue(H_p, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H_p"), base_rng__), 
                                "assigning variable rts_p");
                } else if (as_bool(logical_eq(distribution, 1))) {
                    current_statement_begin__ = 157;
                    stan::model::assign(rts_p, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                multi_student_t_rng(nu, stan::model::rvalue(mu_p, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu_p"), stan::model::rvalue(H_p, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H_p"), base_rng__), 
                                "assigning variable rts_p");
                }
            }
            current_statement_begin__ = 175;
            stan::math::assign(rts_forecasted, stan::model::rvalue(rts_p, stan::model::cons_list(stan::model::index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)), stan::model::nil_index_list()), "rts_p"));
            current_statement_begin__ = 176;
            stan::math::assign(H_forecasted, stan::model::rvalue(H_p, stan::model::cons_list(stan::model::index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)), stan::model::nil_index_list()), "H_p"));
            current_statement_begin__ = 177;
            stan::math::assign(R_forecasted, stan::model::rvalue(R_p, stan::model::cons_list(stan::model::index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)), stan::model::nil_index_list()), "R_p"));
            current_statement_begin__ = 178;
            stan::math::assign(mu_forecasted, stan::model::rvalue(mu_p, stan::model::cons_list(stan::model::index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)), stan::model::nil_index_list()), "mu_p"));
            current_statement_begin__ = 179;
            if (as_bool(compute_log_lik)) {
                current_statement_begin__ = 180;
                if (as_bool(logical_eq(distribution, 0))) {
                    current_statement_begin__ = 181;
                    for (int i = 1; i <= ahead; ++i) {
                        current_statement_begin__ = 182;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    multi_normal_log(get_base1(future_rts, i, "future_rts", 1), get_base1(mu_forecasted, i, "mu_forecasted", 1), get_base1(H_forecasted, i, "H_forecasted", 1)), 
                                    "assigning variable log_lik");
                    }
                } else if (as_bool(logical_eq(distribution, 1))) {
                    current_statement_begin__ = 185;
                    for (int i = 1; i <= ahead; ++i) {
                        current_statement_begin__ = 186;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    multi_student_t_log(get_base1(future_rts, i, "future_rts", 1), nu, get_base1(mu_forecasted, i, "mu_forecasted", 1), get_base1(H_forecasted, i, "H_forecasted", 1)), 
                                    "assigning variable log_lik");
                    }
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 86;
            size_t rts_p_j_1_max__ = nt;
            size_t rts_p_k_0_max__ = (ahead + std::max(Q, P));
            for (size_t j_1__ = 0; j_1__ < rts_p_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rts_p_k_0_max__; ++k_0__) {
                    vars__.push_back(rts_p[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 87;
            size_t rts_forecasted_j_1_max__ = nt;
            size_t rts_forecasted_k_0_max__ = ahead;
            for (size_t j_1__ = 0; j_1__ < rts_forecasted_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rts_forecasted_k_0_max__; ++k_0__) {
                    vars__.push_back(rts_forecasted[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 89;
            size_t H_p_i_0_max__ = (ahead + std::max(Q, P));
            for (size_t i_0__ = 0; i_0__ < H_p_i_0_max__; ++i_0__) {
                stan::math::check_cov_matrix(function__, "H_p[i_0__]", H_p[i_0__]);
            }
            size_t H_p_j_2_max__ = nt;
            size_t H_p_j_1_max__ = nt;
            size_t H_p_k_0_max__ = (ahead + std::max(Q, P));
            for (size_t j_2__ = 0; j_2__ < H_p_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < H_p_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < H_p_k_0_max__; ++k_0__) {
                        vars__.push_back(H_p[k_0__](j_1__, j_2__));
                    }
                }
            }
            current_statement_begin__ = 90;
            size_t R_p_i_0_max__ = (ahead + std::max(Q, P));
            for (size_t i_0__ = 0; i_0__ < R_p_i_0_max__; ++i_0__) {
                stan::math::check_corr_matrix(function__, "R_p[i_0__]", R_p[i_0__]);
            }
            size_t R_p_j_2_max__ = nt;
            size_t R_p_j_1_max__ = nt;
            size_t R_p_k_0_max__ = (ahead + std::max(Q, P));
            for (size_t j_2__ = 0; j_2__ < R_p_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < R_p_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < R_p_k_0_max__; ++k_0__) {
                        vars__.push_back(R_p[k_0__](j_1__, j_2__));
                    }
                }
            }
            current_statement_begin__ = 91;
            size_t H_forecasted_i_0_max__ = ahead;
            for (size_t i_0__ = 0; i_0__ < H_forecasted_i_0_max__; ++i_0__) {
                stan::math::check_cov_matrix(function__, "H_forecasted[i_0__]", H_forecasted[i_0__]);
            }
            size_t H_forecasted_j_2_max__ = nt;
            size_t H_forecasted_j_1_max__ = nt;
            size_t H_forecasted_k_0_max__ = ahead;
            for (size_t j_2__ = 0; j_2__ < H_forecasted_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < H_forecasted_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < H_forecasted_k_0_max__; ++k_0__) {
                        vars__.push_back(H_forecasted[k_0__](j_1__, j_2__));
                    }
                }
            }
            current_statement_begin__ = 92;
            size_t R_forecasted_i_0_max__ = ahead;
            for (size_t i_0__ = 0; i_0__ < R_forecasted_i_0_max__; ++i_0__) {
                stan::math::check_corr_matrix(function__, "R_forecasted[i_0__]", R_forecasted[i_0__]);
            }
            size_t R_forecasted_j_2_max__ = nt;
            size_t R_forecasted_j_1_max__ = nt;
            size_t R_forecasted_k_0_max__ = ahead;
            for (size_t j_2__ = 0; j_2__ < R_forecasted_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < R_forecasted_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < R_forecasted_k_0_max__; ++k_0__) {
                        vars__.push_back(R_forecasted[k_0__](j_1__, j_2__));
                    }
                }
            }
            current_statement_begin__ = 94;
            size_t rr_p_j_2_max__ = nt;
            size_t rr_p_j_1_max__ = nt;
            size_t rr_p_k_0_max__ = (ahead + std::max(Q, P));
            for (size_t j_2__ = 0; j_2__ < rr_p_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < rr_p_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < rr_p_k_0_max__; ++k_0__) {
                        vars__.push_back(rr_p[k_0__](j_1__, j_2__));
                    }
                }
            }
            current_statement_begin__ = 95;
            size_t mu_p_j_1_max__ = nt;
            size_t mu_p_k_0_max__ = (ahead + std::max(Q, P));
            for (size_t j_1__ = 0; j_1__ < mu_p_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < mu_p_k_0_max__; ++k_0__) {
                    vars__.push_back(mu_p[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 96;
            size_t mu_forecasted_j_1_max__ = nt;
            size_t mu_forecasted_k_0_max__ = ahead;
            for (size_t j_1__ = 0; j_1__ < mu_forecasted_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < mu_forecasted_k_0_max__; ++k_0__) {
                    vars__.push_back(mu_forecasted[k_0__](j_1__));
                }
            }
            current_statement_begin__ = 98;
            size_t beta_j_2_max__ = nt;
            size_t beta_j_1_max__ = (nt + 1);
            for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    vars__.push_back(beta(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 102;
            size_t log_lik_k_0_max__ = (logical_eq(compute_log_lik, 1) ? ahead : 0 );
            for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
                vars__.push_back(log_lik[k_0__]);
            }
            current_statement_begin__ = 105;
            size_t A_part_p_j_2_max__ = nt;
            size_t A_part_p_j_1_max__ = nt;
            for (size_t j_2__ = 0; j_2__ < A_part_p_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < A_part_p_j_1_max__; ++j_1__) {
                    vars__.push_back(A_part_p(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 106;
            size_t B_part_p_j_2_max__ = nt;
            size_t B_part_p_j_1_max__ = nt;
            for (size_t j_2__ = 0; j_2__ < B_part_p_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < B_part_p_j_1_max__; ++j_1__) {
                    vars__.push_back(B_part_p(j_1__, j_2__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_forecastBEKK";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t phi0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < phi0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_j_2_max__ = nt;
        size_t phi_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < phi_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t theta_j_2_max__ = nt;
        size_t theta_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta1_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t C_R_j_2_max__ = nt;
        size_t C_R_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < C_R_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < C_R_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "C_R" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "nu";
        param_names__.push_back(param_name_stream__.str());
        size_t Cnst_j_2_max__ = nt;
        size_t Cnst_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < Cnst_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Cnst_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Cnst" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t H_j_2_max__ = nt;
        size_t H_j_1_max__ = nt;
        size_t H_k_0_max__ = T;
        for (size_t j_2__ = 0; j_2__ < H_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < H_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "H" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t rr_j_2_max__ = nt;
        size_t rr_j_1_max__ = nt;
        size_t rr_k_0_max__ = (T - 1);
        for (size_t j_2__ = 0; j_2__ < rr_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rr_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "rr" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t mu_j_1_max__ = nt;
        size_t mu_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t A_j_2_max__ = nt;
        size_t A_j_1_max__ = nt;
        size_t A_k_0_max__ = Q;
        for (size_t j_2__ = 0; j_2__ < A_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < A_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < A_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "A" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t B_j_2_max__ = nt;
        size_t B_j_1_max__ = nt;
        size_t B_k_0_max__ = P;
        for (size_t j_2__ = 0; j_2__ < B_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < B_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < B_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "B" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t corH_j_2_max__ = nt;
        size_t corH_j_1_max__ = nt;
        size_t corH_k_0_max__ = T;
        for (size_t j_2__ = 0; j_2__ < corH_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < corH_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < corH_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "corH" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t rts_p_j_1_max__ = nt;
        size_t rts_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_1__ = 0; j_1__ < rts_p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < rts_p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rts_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rts_forecasted_j_1_max__ = nt;
        size_t rts_forecasted_k_0_max__ = ahead;
        for (size_t j_1__ = 0; j_1__ < rts_forecasted_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < rts_forecasted_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rts_forecasted" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t H_p_j_2_max__ = nt;
        size_t H_p_j_1_max__ = nt;
        size_t H_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_2__ = 0; j_2__ < H_p_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < H_p_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < H_p_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "H_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t R_p_j_2_max__ = nt;
        size_t R_p_j_1_max__ = nt;
        size_t R_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_2__ = 0; j_2__ < R_p_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < R_p_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < R_p_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "R_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t H_forecasted_j_2_max__ = nt;
        size_t H_forecasted_j_1_max__ = nt;
        size_t H_forecasted_k_0_max__ = ahead;
        for (size_t j_2__ = 0; j_2__ < H_forecasted_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < H_forecasted_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < H_forecasted_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "H_forecasted" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t R_forecasted_j_2_max__ = nt;
        size_t R_forecasted_j_1_max__ = nt;
        size_t R_forecasted_k_0_max__ = ahead;
        for (size_t j_2__ = 0; j_2__ < R_forecasted_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < R_forecasted_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < R_forecasted_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "R_forecasted" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t rr_p_j_2_max__ = nt;
        size_t rr_p_j_1_max__ = nt;
        size_t rr_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_2__ = 0; j_2__ < rr_p_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rr_p_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rr_p_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "rr_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t mu_p_j_1_max__ = nt;
        size_t mu_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_1__ = 0; j_1__ < mu_p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_forecasted_j_1_max__ = nt;
        size_t mu_forecasted_k_0_max__ = ahead;
        for (size_t j_1__ = 0; j_1__ < mu_forecasted_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_forecasted_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_forecasted" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta_j_2_max__ = nt;
        size_t beta_j_1_max__ = (nt + 1);
        for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t log_lik_k_0_max__ = (logical_eq(compute_log_lik, 1) ? ahead : 0 );
        for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t A_part_p_j_2_max__ = nt;
        size_t A_part_p_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < A_part_p_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < A_part_p_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "A_part_p" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t B_part_p_j_2_max__ = nt;
        size_t B_part_p_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < B_part_p_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < B_part_p_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "B_part_p" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t phi0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < phi0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_j_2_max__ = nt;
        size_t phi_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < phi_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t theta_j_2_max__ = nt;
        size_t theta_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta1_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t C_R_j_1_max__ = ((nt * (nt - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < C_R_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "C_R" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "nu";
        param_names__.push_back(param_name_stream__.str());
        size_t Cnst_j_1_max__ = (nt + ((nt * (nt - 1)) / 2));
        for (size_t j_1__ = 0; j_1__ < Cnst_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Cnst" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t H_j_1_max__ = (nt + ((nt * (nt - 1)) / 2));
        size_t H_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < H_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "H" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rr_j_2_max__ = nt;
        size_t rr_j_1_max__ = nt;
        size_t rr_k_0_max__ = (T - 1);
        for (size_t j_2__ = 0; j_2__ < rr_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rr_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "rr" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t mu_j_1_max__ = nt;
        size_t mu_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t A_j_2_max__ = nt;
        size_t A_j_1_max__ = nt;
        size_t A_k_0_max__ = Q;
        for (size_t j_2__ = 0; j_2__ < A_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < A_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < A_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "A" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t B_j_2_max__ = nt;
        size_t B_j_1_max__ = nt;
        size_t B_k_0_max__ = P;
        for (size_t j_2__ = 0; j_2__ < B_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < B_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < B_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "B" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t corH_j_1_max__ = ((nt * (nt - 1)) / 2);
        size_t corH_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < corH_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < corH_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "corH" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t rts_p_j_1_max__ = nt;
        size_t rts_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_1__ = 0; j_1__ < rts_p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < rts_p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rts_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rts_forecasted_j_1_max__ = nt;
        size_t rts_forecasted_k_0_max__ = ahead;
        for (size_t j_1__ = 0; j_1__ < rts_forecasted_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < rts_forecasted_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rts_forecasted" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t H_p_j_1_max__ = (nt + ((nt * (nt - 1)) / 2));
        size_t H_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_1__ = 0; j_1__ < H_p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < H_p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "H_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t R_p_j_1_max__ = ((nt * (nt - 1)) / 2);
        size_t R_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_1__ = 0; j_1__ < R_p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < R_p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "R_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t H_forecasted_j_1_max__ = (nt + ((nt * (nt - 1)) / 2));
        size_t H_forecasted_k_0_max__ = ahead;
        for (size_t j_1__ = 0; j_1__ < H_forecasted_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < H_forecasted_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "H_forecasted" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t R_forecasted_j_1_max__ = ((nt * (nt - 1)) / 2);
        size_t R_forecasted_k_0_max__ = ahead;
        for (size_t j_1__ = 0; j_1__ < R_forecasted_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < R_forecasted_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "R_forecasted" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rr_p_j_2_max__ = nt;
        size_t rr_p_j_1_max__ = nt;
        size_t rr_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_2__ = 0; j_2__ < rr_p_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rr_p_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rr_p_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "rr_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t mu_p_j_1_max__ = nt;
        size_t mu_p_k_0_max__ = (ahead + std::max(Q, P));
        for (size_t j_1__ = 0; j_1__ < mu_p_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_p_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_p" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_forecasted_j_1_max__ = nt;
        size_t mu_forecasted_k_0_max__ = ahead;
        for (size_t j_1__ = 0; j_1__ < mu_forecasted_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < mu_forecasted_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_forecasted" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta_j_2_max__ = nt;
        size_t beta_j_1_max__ = (nt + 1);
        for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t log_lik_k_0_max__ = (logical_eq(compute_log_lik, 1) ? ahead : 0 );
        for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t A_part_p_j_2_max__ = nt;
        size_t A_part_p_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < A_part_p_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < A_part_p_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "A_part_p" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t B_part_p_j_2_max__ = nt;
        size_t B_part_p_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < B_part_p_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < B_part_p_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "B_part_p" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
}; // model
}  // namespace
typedef model_forecastBEKK_namespace::model_forecastBEKK stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
