% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-parameters.R
\name{c_parametrizations}
\alias{c_parametrizations}
\alias{c_sqrtexp2bessel}
\alias{c_bessel2sqrtexp}
\title{Convert between parametrizations of the c parameter of the SDM distribution}
\usage{
c_sqrtexp2bessel(c, kappa)

c_bessel2sqrtexp(c, kappa)
}
\arguments{
\item{c}{Vector of memory strength values}

\item{kappa}{Vector of precision values}
}
\value{
A numeric vector of the same length as \code{c} and \code{kappa}.
}
\description{
Convert between parametrizations of the c parameter of the SDM distribution
}
\details{
\code{c_bessel2sqrtexp} converts the memory strength parameter (c)
from the bessel parametrization to the sqrtexp parametrization,
\code{c_sqrtexp2bessel} converts from the sqrtexp parametrization to the
bessel parametrization.

See \href{https://venpopov.github.io/bmm/articles/bmm_sdm_simple.html}{the online article} for details on the
parameterization. The sqrtexp parametrization is the default in the
\code{bmm} package.
}
\examples{
c_bessel <- c_sqrtexp2bessel(c = 4, kappa = 3)
c_sqrtexp <- c_bessel2sqrtexp(c = c_bessel, kappa = 3)

}
\keyword{transform}
