% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss_non_convex.R
\name{tsvmLoss}
\alias{tsvmLoss}
\title{Non convex loss function for transductive SVM}
\usage{
tsvmLoss(x, y, loss.weights = 1)
}
\arguments{
\item{x}{matrix of training instances (one instance by row)}

\item{y}{a logical vector representing the training labels for each instance in x. NA are allowed when labels is unknown.}

\item{loss.weights}{numeric vector of loss weights to incure for each instance of x. 
Vector length should match length(y), but values are cycled if not of identical size.}
}
\value{
a function taking one argument w and computing the loss value and the gradient at point w
}
\description{
Non convex loss function for transductive SVM
}
\examples{
x <- cbind(intercept=100,data.matrix(iris[1:2]))
y <- iris$Species=="virginica"
y[iris$Species=="setosa"] <- NA
w <- nrbm(tsvmLoss(x,y),convexRisk=FALSE)
table(predict(w,x),iris$Species)
}
\seealso{
nrbm
}
