% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_misc.R
\name{iterative.hclust}
\alias{iterative.hclust}
\title{Perform multiple hierachical clustering on random subsets of a dataset}
\usage{
iterative.hclust(x, seeds = 1:100, row.rate = 0.3, col.rate = 0.1,
  max.cluster = 10L, ret.height = FALSE, hc.method = function(x, PCs
  = 1:6, ...) {     hclust(dist(prcomp(x, rank. = max(PCs))$x[, PCs, drop =
  FALSE]), ...) }, ...)
}
\arguments{
\item{x}{the numeric matrix containing the data to cluster (one instance per row)}

\item{seeds}{a vector of random seed to use.}

\item{row.rate, col.rate}{numeric value in [0,1] to specify the proportion of instance 
(resp. feature) to subset at each random iteration.}

\item{max.cluster}{upper bound on the number of expected cluster (can by +Inf).}

\item{ret.height}{a logical to specify whether the average merging height should be returned.}

\item{hc.method}{a clustering method of arity 1, taking as input a random subset of the 
input matrix x and returning an hclust object}

\item{...}{additional arguments are passed to the hc.method}
}
\value{
a list of 3 square matrices N,H,K of size nrow(x): N is the number of 
        time each pair of instance as been seen in the random subsets; H is the
        corresponding sum of heights for the pairs; K is the sum of the number of split
        possible that still preserve the two samples into the same cluster.
}
\description{
Perform multiple hierachical clustering on random subsets of a dataset
}
\author{
Julien Prados
}
