% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bndovb.R
\name{bndovb}
\alias{bndovb}
\title{bndovb}
\usage{
bndovb(
  maindat,
  auxdat,
  depvar,
  ovar,
  comvar,
  method = 1,
  mainweights = NULL,
  auxweights = NULL,
  signres = NULL
)
}
\arguments{
\item{maindat}{Main data set. It must be a data frame.}

\item{auxdat}{Auxiliary data set. It must be a data frame.}

\item{depvar}{A name of a dependent variable in main dataset}

\item{ovar}{A name of an omitted variable in main dataset which exists in auxiliary data}

\item{comvar}{A vector of the names of common regressors existing in both main data and auxiliary data}

\item{method}{CDF and Quantile function estimation method.
Users can choose either 1 or 2. If the method is 1, the CDF and quantile function is estimated assuming a parametric normal distribution.
If the method is 2, the CDF and quantile function is estimated using a nonparaemtric estimator in Li and Racine(2008) \doi{10.1198/073500107000000250}, Li, Lin, and Racine(2013) \doi{10.1080/07350015.2012.738955}.
Default is 1.}

\item{mainweights}{An optional weight vector for the main dataset. The length must be equal to the number of rows of 'maindat'.}

\item{auxweights}{An optional weight vector for the auxiliary dataset. The length must be equal to the number of rows of 'auxdat'.}

\item{signres}{An option to impose a sign restriction on a coefficient of an omitted variable. Set either NULL or pos or neg.
Default is NULL. If NULL, there is no sign restriction.
If 'pos', the estimator imposes an extra restriction that the coefficient of an omitted variable must be positive.
If 'neg', the estimator imposes an extra restriction that the coefficient of an omitted variable must be negative.}
}
\value{
Returns a list of 4 components : \describe{
\item{hat_beta_l}{lower bound estimates of regression coefficients}

\item{hat_beta_u}{upper bound estimates of regression coefficients}

\item{mu_l}{lower bound estimate of E[ovar*depvar]}

\item{mu_u}{upper bound estimate of E[ovar*depvar]}}
}
\description{
This function runs a two sample least squares when auxiliary data contains every right-hand side regressor
and main data contains a dependent variable and every right-hand side regressor but one omitted variable.
}
\examples{
data(maindat_nome)
data(auxdat_nome)

bndovb(maindat=maindat_nome,auxdat=auxdat_nome,depvar="y",ovar="x1",comvar=c("x2","x3"),method=1)


}
\references{
\describe{
\item{Hwang, Yujung (2021)}{Bounding Omitted Variable Bias Using Auxiliary Data. Available at SSRN.\doi{10.2139/ssrn.3866876}}}
}
\author{
Yujung Hwang, \email{yujungghwang@gmail.com}
}
