% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.summary.R
\name{network.gelman.diag}
\alias{network.gelman.diag}
\title{Use coda package to find Gelman-Rubin diagnostics}
\usage{
network.gelman.diag(result, extra.pars = NULL, only.pars = NULL)
}
\arguments{
\item{result}{Object created by \code{\link{network.run}} function}

\item{extra.pars}{Extra parameters that the user wants to display other than the default parameters.}

\item{only.pars}{Parameters that user wants to display. This gets rids of other default parameters user doesn't want to show.}
}
\value{
Returns gelman-rubin diagnostics
}
\description{
This function uses coda package to find Gelman-Rubin diagnostics.
}
\examples{
network <- with(statins, {
 network.data(Outcomes, Study, Treat, N = N, response = "binomial",
 Treat.order = c("Placebo", "Statin"), covariate = covariate, covariate.type = "discrete")
})
\donttest{
result <- network.run(network)
network.gelman.diag(result, extra.pars = c("Eta"))
}
}
