% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.levels.R
\name{check.levels}
\alias{check.levels}
\title{Check if factor need to be converted in numeric.}
\usage{
check.levels(data.to.work, level.max, dataset.name)
}
\arguments{
\item{data.to.work}{is a dataset to be checked / updated.}

\item{level.max}{is the maximum number of levels to be tolerated.}

\item{dataset.name}{is a name of a data frame containing the variables to be checked.}
}
\description{
Receives a dataset and the maximum number of levels a factor would have. It will
transform all factor variables exceeding this limit.
}
\details{
This function receives a dataset, scan all variables of it, check if each variable is
a factor and if "yes", it will check if the number of factors of this variable exceeds
the maximum number of levels previously passed as parameter. If it exceeds then will convert
the variable to numeric type.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Load packages
library(bnpa)
# Use working datasets from package
data.to.work <- dataQualiN
head(data.to.work)
###################################################################################
# check.levels.R - Check if factor need to be converted in numeric.
###################################################################################
# Adding dichotomic data to data.to.work, function will return TRUE
data.to.work$Z <- round(runif(500, min=0, max=1000),2)
# Converting the numeric variable into factor
data.to.work$Z <- factor(data.to.work$Z)
# Showing the data structure
str(data.to.work)
# Identify all variables with more than 2 factors and convert it to numeric (the 'Z' variable)
level.max <- 2
dataset.name <- "data.to.work"
check.levels(data.to.work, level.max, dataset.name)
# Showing the data structure
str(data.to.work)
}
\author{
Elias Carvalho
}

