% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admix_prop_1d_circular.R
\name{admix_prop_1d_circular}
\alias{admix_prop_1d_circular}
\title{Construct admixture proportion matrix for circular 1D geography}
\usage{
admix_prop_1d_circular(n_ind, k_subpops, sigma = NA,
  coord_ind_first = 2 * pi/(2 * n_ind), coord_ind_last = 2 * pi * (1 -
  1/(2 * n_ind)), bias_coeff, coanc_subpops, fst)
}
\arguments{
\item{n_ind}{Number of individuals}

\item{k_subpops}{Number of intermediate subpopulations}

\item{sigma}{Spread of intermediate subpopulations (approximate standard deviation of Von Mises densities, see above)
The edge cases \code{sigma = 0} and \code{sigma = Inf} are handled appropriately!}

\item{coord_ind_first}{Location of first individual}

\item{coord_ind_last}{Location of last individual

OPTIONS FOR BIAS COEFFICIENT VERSION}

\item{bias_coeff}{The desired bias coefficient, which specifies \eqn{\sigma} indirectly.
Required if \code{sigma} is missing.}

\item{coanc_subpops}{The length-\eqn{k} vector of inbreeding coefficients (or \eqn{F_{ST}}{FST}'s) of the intermediate subpopulations, up to a scaling factor (which cancels out in calculations).
Required if \code{sigma} is missing.}

\item{fst}{The desired final \eqn{F_{ST}}{FST} of the admixed individuals.
Required if \code{sigma} is missing.}
}
\value{
If \code{sigma} was provided, the \eqn{n \times k}{n-by-k} admixture proportion matrix.
If \code{sigma} is missing, a named list is returned containing \code{admix_proportions}, the rescaled \code{coanc_subpops}, and the \code{sigma} that together give the desired \eqn{bias_coeff} and final \eqn{F_{ST}}{FST} of the admixed individuals.
}
\description{
Assumes \eqn{k} intermediate subpopulations placed along a circumference (the \eqn{[0, 2\pi]} line that wraps around) with even spacing spread by random walks (see details below), then \eqn{n} individuals sampled equally spaced in \eqn{[a,b]} (default \eqn{[0, 2\pi]} with a small gap so first and last individual do not overlap) draw their admixture proportions relative to the Von Mises density that models the random walks of each of these intermediate subpopulations.
The spread of the random walks (the \eqn{\sigma=1/\sqrt{\kappa}} of the Von Mises densities) is set to \code{sigma} if not missing, otherwise \eqn{\sigma} is found numerically to give the desired bias coefficient \code{bias_coeff}, the coancestry matrix of the intermediate subpopulations \code{coanc_subpops} (up to a scalar factor), and the final \eqn{F_{ST}}{FST} of the admixed individuals (see details below).
}
\details{
Assuming the full range of \eqn{[0, 2\pi]} is considered, and the first and last individuals do not overlap, the gap between individuals is \eqn{\Delta = 2 \pi / n}.
To not have any individuals on the edge, we place the first individual at \eqn{\Delta / 2} and the last at \eqn{2 \pi - \Delta / 2}.
The location of subpopulation \eqn{j} is
\deqn{\Delta / 2 + (j-1/2)/k (2 \pi - \Delta),}
chosen to agree with the default correspondence between individuals and subpopulations of the linear 1D geography admixture scenario (\code{\link{admix_prop_1d_linear}}).

When \code{sigma} is missing, the function determines its value using the desired \code{bias_coeff}, \code{coanc_subpops} up to a scalar factor, and \code{fst}.
Uniform weights for the final generalized \eqn{F_{ST}}{FST} are assumed.
The scaling factor of the input \code{coanc_subpops} is irrelevant because it cancels out in \code{bias_coeff}; after \code{sigma} is found, \code{coanc_subpops} is rescaled to give the desired final \eqn{F_{ST}}{FST}.
However, the function stops with a fatal error if the rescaled \code{coanc_subpops} takes on any values greater than 1, which are not allowed since \code{coanc_subpops} are IBD probabilities.
}
\examples{
# admixture matrix for 1000 individuals drawing alleles from 10 subpops
# and a spread of about 2 standard deviations along the circular 1D geography
admix_proportions <- admix_prop_1d_circular(n_ind = 1000, k_subpops = 10, sigma = 2)

# a similar model but with a bias coefficient of exactly 1/2
k_subpops <- 10
# FST vector for intermediate independent subpops, up to a factor (will be rescaled below)
coanc_subpops <- 1 : k_subpops
obj <- admix_prop_1d_circular(
    n_ind = 1000,
    k_subpops = k_subpops,
    bias_coeff = 0.5,
    coanc_subpops = coanc_subpops,
    fst = 0.1 # desired final FST of admixed individuals
)

# in this case return value is a named list with three items:
admix_proportions <- obj$admix_proportions

# rescaled coancestry data (matrix or vector) for intermediate subpops
coanc_subpops <- obj$coanc_subpops

# and the sigma that gives the desired bias_coeff and final FST
sigma <- obj$sigma

}
