% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_p_subpops.R
\name{draw_p_subpops}
\alias{draw_p_subpops}
\title{Draw allele frequencies for independent subpopulations}
\usage{
draw_p_subpops(p_anc, inbr_subpops, m_loci = NA, k_subpops = NA)
}
\arguments{
\item{p_anc}{The length-\eqn{m} vector of ancestral allele frequencies per locus.}

\item{inbr_subpops}{The length-\eqn{k} vector of subpopulation \eqn{F_{ST}}{FST} values.}

\item{m_loci}{Optional.
The desired number of loci \eqn{m}, to be used if \code{p_anc} is a scalar.
Stops if both \code{length(p_anc) > 1} and \code{m_loci} are set and they disagree.}

\item{k_subpops}{Optional.
The desired number of subpopulations \eqn{k}, to be used if \code{inbr_subpops} is a scalar.
Stops if both \code{length(inbr_subpops) > 1} and \code{k_subpops} are set and they disagree.}
}
\value{
The \eqn{m \times k}{m-by-k} matrix of independent subpopulation allele frequencies
}
\description{
Allele frequencies \eqn{p_i^{S_u}} for independent subpopulations \eqn{S_u} at locus \eqn{i} are drawn from the Balding-Nichols distribution with ancestral allele frequency \eqn{p_i^T} and \eqn{F_{ST}}{FST} parameter \eqn{f^T_{S_u}} as
\deqn{p_i^{S_u} \sim \mbox{Beta}(\nu_u p_i^T, \nu_u (1-p_i^T)),}
where \eqn{\nu_u = 1/f^T_{S_u} - 1}.
Below \eqn{m} is the number of loci and \eqn{k} is the number of subpopulations.
}
\examples{
# a typical, non-trivial example
# number of loci
m_loci <- 10
# random vector of ancestral allele frequencies
p_anc <- draw_p_anc(m_loci)
# FST values for two subpops
inbr_subpops <- c(0.1, 0.3)
# matrix of intermediate subpop allele freqs
p_subpops <- draw_p_subpops(p_anc, inbr_subpops)

# special case of scalar p_anc
p_subpops <- draw_p_subpops(p_anc = 0.5, inbr_subpops, m_loci = m_loci)
stopifnot ( nrow( p_subpops ) == m_loci )

# special case of scalar inbr_subpops
k_subpops <- 2
p_subpops <- draw_p_subpops(p_anc, inbr_subpops = 0.2, k_subpops = k_subpops)
stopifnot ( ncol( p_subpops ) == k_subpops )

# both main parameters scalars but return value still matrix
p_subpops <- draw_p_subpops(p_anc = 0.5, inbr_subpops = 0.2, m_loci = m_loci, k_subpops = k_subpops)
stopifnot ( nrow( p_subpops ) == m_loci )
stopifnot ( ncol( p_subpops ) == k_subpops )

# passing scalar parameters without setting dimensions separately results in a 1x1 matrix
p_subpops <- draw_p_subpops(p_anc = 0.5, inbr_subpops = 0.2)
stopifnot ( nrow( p_subpops ) == 1 )
stopifnot ( ncol( p_subpops ) == 1 )

}
