% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst_admix.R
\name{fst_admix}
\alias{fst_admix}
\title{Calculate FST for the admixed individuals}
\usage{
fst_admix(admix_proportions, coanc_subpops, weights = NULL)
}
\arguments{
\item{admix_proportions}{The \code{n}-by-\code{k} admixture proportion matrix}

\item{coanc_subpops}{Either the \code{k}-by-\code{k} intermediate subpopulation coancestry matrix (for the complete admixture model), or the length-\code{k} vector of intermediate subpopulation FST values (for the BN-PSD model; assumes zero coancestries between subpopulations), or a scalar FST value shared by all intermediate subpopulations (also assumes zero coancestry between subpopulations).}

\item{weights}{Optional length-\code{n} vector of weights for individuals that define their generalized FST (default uniform weights)}
}
\value{
The generalized FST of the admixed individuals
}
\description{
This function returns the generalized FST of the admixed individuals given their admixture proportion matrix, the coancestry matrix of intermediate subpopulations (or its special cases, see \code{coanc_subpops} parameter below), and optional weights for individuals.
This FST equals the weighted mean of the diagonal of the coancestry matrix (see \verb{\link{coanc_admix}}).
Below there are \code{n} individuals and \code{k} intermediate subpopulations.
}
\examples{
# set desired parameters
# number of individuals
n_ind <- 1000
# number of intermediate subpopulations
k_subpops <- 10

# differentiation of intermediate subpopulations
coanc_subpops <- ( 1 : k_subpops ) / k_subpops

# construct admixture proportions
admix_proportions <- admix_prop_1d_linear(n_ind, k_subpops, sigma = 1)

# lastly, calculate Fst!!! (uniform weights in this case)
fst_admix(admix_proportions, coanc_subpops)

}
