% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aoi.R
\name{aoi}
\alias{aoi}
\title{Build area of interest (A.O.I.)}
\usage{
aoi(msk, mskSub = NULL, xy = FALSE)
}
\arguments{
\item{msk}{a character (path to raster file), a raster (object of class "RasterLayer"), or a list of rasters. 
The reference raster(s) to be used as mask. All model outputs will have the same resolution and same extent as this raster(s). 
All locations with no data (i.e. NA) cells in \code{msk} will be ignored as well.}

\item{mskSub}{vector. The subset values from \code{msk} which should be considered to build the area of interest. All other values will be ignored and returned as NA.}

\item{xy}{logical. Should return a two column matrix of coordinates? If FALSEan object of class RasterLayer is returned.}
}
\value{
An object of class RasterLayer (default), or a matrix of coordinates of mask cells. In the former case, valid cells (i.e. the area of interest) will have value 1, \code{NA} otherwise.
}
\description{
This function creates a raster defining the area of interest, by unioning the input rasters or using a user defined mask.
When \code{msk} is specified, resolution and extent are set equal to it, otherwise
to the finest resolution among input spatial data and unioning the extents of input spatial data.
}
\details{
All model outputs will have the same resolution and same extent as inherited from \code{msk}. All locations with no data (i.e. NA) cells 
from \code{msk} will be ignored as well.
}
\examples{
## Make a mask from a group of input layers:
data(ConwyData)
network <- LandUseChange
spatialData <- c(currentLU, slope, status)
m <- aoi(spatialData)
m

## Plot mask
library(raster)
m <- aoi(currentLU)
plot(m)

## Make mask from a subset of values and plot
m <- aoi(currentLU, mskSub=c(2,3))
plot(m)

## Return coordinates of valid mask locations
coord <- aoi(currentLU, xy=TRUE)
head(coord)
}
\seealso{
\code{\link{extractByMask}}
}

