% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result_formatting.R
\name{extract_boinet_data}
\alias{extract_boinet_data}
\title{Extract Tidy Data from BOIN-ET Results}
\usage{
extract_boinet_data(boinet_result)
}
\arguments{
\item{boinet_result}{Result object from any boinet function}
}
\value{
List containing tidy data frames
}
\description{
Convenience function to extract tidy data frames from boinet results.
This is a wrapper for format_boinet_results with tidy output.
}
\examples{
\dontrun{
result <- gboinet(...)
tidy_data <- extract_boinet_data(result)

# Use tidy data for custom analysis
library(ggplot2)
tidy_data$operating_characteristics |>
  ggplot(aes(x = dose_level, y = selection_prob)) +
  geom_col()
}
}
