% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahr_estimation.R
\name{ahr_estimation}
\alias{ahr_estimation}
\title{Average Hazard Ratio Estimation}
\usage{
ahr_estimation(x_subg, dummy_subg, est_coef, h0, gamma = 1)
}
\arguments{
\item{x_subg}{(\code{matrix})\cr the matrix with the subgroup covariates.}

\item{dummy_subg}{(\code{matrix})\cr the dummy matrix with the subgroup
covariates.}

\item{est_coef}{(\code{matrix})\cr the estimated coefficients from the fitted
model.}

\item{h0}{(\code{numeric})\cr the vector with the cumulative baseline hazard.}

\item{gamma}{(\code{scalar})\cr numeric value defining the weights to obtain
the average hazard ratio. Default is 1 (in this case the average hazard
ratio obtained can be interpreted as the odds of concordance).}
}
\value{
Average hazard ratio
}
\description{
Function to obtain the average hazard ratio.
}
\examples{
ahr_estimation(
  elastic_net_surv$design1, elastic_net_surv$dummy1,
  elastic_net_surv$est_coef, elastic_net_surv$h0
)
}
