% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.horseshoe}
\alias{summary.horseshoe}
\title{Summary Horseshoe Function}
\usage{
\method{summary}{horseshoe}(object, conf = 0.95, gamma = 1, l = NULL, m = 50, ...)
}
\arguments{
\item{object}{(\code{horseshoe})\cr the horseshoe object.}

\item{conf}{(\code{scalar})\cr the level of the credible intervals. Default is
0.95.}

\item{gamma}{(\code{scalar})\cr numeric value defining the weights to obtain
the average hazard ratio. Default is 1 (in this case the average hazard
ratio obtained can be interpreted as the odds of concordance). Just needed
when using survival data.}

\item{l}{(\code{scalar})\cr the maximum value of time that wants to be studied to
obtain the average hazard ratio. Default is the maximum value of time when
there was an event. Just needed when using survival data.}

\item{m}{(\code{scalar})\cr the value that defines the equally spaced time points
where the survival curves are going to be studied. Default is 50. Just needed
when using survival data.}

\item{...}{Arguments of summary.}
}
\value{
Object of class \code{summary.horseshoe} which is a \code{list} with the
approximated posterior distribution of the treatment
effects, a \code{data.frame} with the estimated subgroup treatment effect
(with the median) and the bounds of the credible intervals, the \code{resptype}
and the confidence level.
}
\description{
Function to obtain the estimated subgroup treatment effects from a \code{horseshoe}
model and a credible interval for them.
}
\examples{
summary(horseshoe_fit_bin)
}
