% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootMice.R
\name{bootMice}
\alias{bootMice}
\title{Bootstrap then impute using mice}
\usage{
bootMice(obsdata, nBoot = 200, nImp = 2, ...)
}
\arguments{
\item{obsdata}{The data frame to be imputed.}

\item{nBoot}{The number of bootstrap samples to take. It is recommended
that you use a minimum of 200.}

\item{nImp}{The number of times to impute each bootstrap sample. Two
is recommended.}

\item{...}{Other arguments that are to be passed to \code{mice}.}
}
\value{
A list of imputed datasets.
}
\description{
Bootstraps an incomplete dataset and then imputes each bootstrap a number
of times using the mice package. The resulting list of bootstrapped then
imputed datasets can be analysed with \code{\link{bootImputeAnalyse}}.
To run this function requires the \code{mice} package to be installed.
}
\examples{
library(mice)

set.seed(564764)

head(ex_linquad)

#bootstrap 10 times and impute each twice
imps <- bootMice(ex_linquad, nBoot=10, nImp=2)
}
