% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_box_lintr.R
\name{use_box_lintr}
\alias{use_box_lintr}
\title{Use lintr with box.linters in your project}
\usage{
use_box_lintr(path = ".", type = c("basic_box", "rhino"))
}
\arguments{
\item{path}{Path to project root where a \code{.lintr} file should be created.
If the \code{.lintr} file already exists, an error will be thrown.}

\item{type}{The kind of configuration to create
\itemize{
\item \code{basic_box} creates a minimal lintr config based on the \code{tidyverse} configuration of \code{lintr}.
This starts with \code{lintr::linters_with_defaults()} and is customized for \code{box} module
compatibility
\item \code{rhino} creates a lintr config based on the \href{https://appsilon.github.io/rhino/articles/explanation/rhino-style-guide.html}{Rhino style guide}
}}
}
\value{
Path to the generated configuration, invisibly.
}
\description{
Create a minimal lintr config file with \code{box} modules support as a starting point
for customization
}
\examples{
\dontrun{
  # use default box-compatible set of linters
  box.linters::use_box_lintr()

  # use `rhino` set of linters
  box.linters::use_box_lintr(type = "rhino")
}
}
