% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bp_ghana}
\alias{bp_ghana}
\title{Task Shifting and Blood Pressure Control in Ghana Data}
\format{
A data frame containing 21 variables pertaining to blood pressure as follows:
\describe{

\item{ID}{Subject ID }
\item{Time_Elapsed}{How much time elapsed between readings: Baseline measurement, 6 month follow-up,
12 month follow-up}
\item{SBP}{Systolic Blood Pressure}
\item{DBP}{Diastolic Blood Pressure}
\item{Age}{Age in Years}
\item{Gender}{0 = Male \cr 1 = Female}
\item{EducationLevel}{Highest Degree Earned:\cr\cr
1 = No Schooling\cr
2 = Primary Schooling (Grades 1 to 6)\cr
3 = Junior Secondary Schooling (JSS) (Grades 7-8)\cr
4 = Secondary School (Grades 9-11)\cr
5 = Completed Secondary School\cr
6 = Technical school certificate\cr
7 = Some college but no degree\cr
8 = Associate degree\cr
9 = Graduate or Professional school (MD, JD, etc.)\cr
999 = Not specified\cr}
\item{EmploymentStatus}{0 = Unemployed \cr 1 = Employed}
\item{Literacy}{0 = Illiterate \cr 1 = Literate}
\item{Smoking}{1 = Smoker \cr 2 = Occasional \cr 3 = Ex-Smoker \cr 4 = Non-Smoker}
\item{Income}{Income level expressed in home currency - Ghanaian cedi (GhC)}
\item{SiteNumber}{Site Location in Ghana:\cr\cr
1 = Suntreso\cr
2 = Ananekrom\cr
3 = Manhiya\cr
4 = Apatrapa\cr
5 = Nkawie\cr
6 = Afrancho\cr
7 = Kumsai South\cr
8 = Mampongteng\cr
9 = Mampong\cr
10 = Bomfa\cr
11 = Ejura\cr
12 = Kofiase\cr
13 = Kokofu\cr
14 = Asuofia\cr
15 = Konongo\cr
16 = Subirisu\cr
17 = Effiduase\cr
18 = Abuakwa\cr
19 = Tafo\cr
20 = KMA\cr
21 = Methodist\cr
22 = Kenyasi\cr
23 = Asonamaso\cr
24 = Juansa\cr
25 = Juaso\cr
26 = Sekyredumase\cr
27 = Nkenkaasu\cr
28 = Berekese\cr
29 = Bekwai\cr
30 = Dwease\cr
31 = Kuntanese \cr
32 = Foase \cr
}
\item{CVRisk}{Cardiovascular Risk Assessment (\%) at Baseline: \cr\cr
1) <10\% \cr
2) 10-20\% \cr
3) 20-30\% \cr
4) 30 to 40\% \cr
999= Missing Data}
\item{BMI}{Body Mass Index}
\item{BMIClassification}{Classification of BMI:\cr\cr
1 = Underweight (<18.5 kg/m^2)\cr
2 = Normal (18.5 to 24.9 kg/m^2)\cr
3 = Overweight (25.0 to 29.9 kg/m^2)\cr
4 = Obese (>30 kg/m^2)\cr
}
\item{PhysicalActivity}{All activity in weighted MET minutes (per week) at Baseline}
\item{TrtorCtrl}{0 = Control\cr 1 = Treatment}
\item{RuralUrban}{0 = Rural\cr 1 = Urban}
\item{DoctorsAvailable}{# of doctors on staff}
\item{NursesAvailable}{# of nurses on staff}
\item{Patientsannually}{# of patients seen annually}

}
}
\source{
Original Paper: \doi{10.1371/journal.pmed.1002561}

Data: \doi{10.5061/dryad.16c9m51}
}
\usage{
bp_ghana
}
\description{
The \code{bp_ghana} data set includes 757 subjects across 32 community health centers who
were partitioned into intervention groups according to a pragmatic cluster-randomized trial
with 389 in the health insurance coverage (HIC) group and 368 in another group consisting
of a combination of HIC with a nurse-led task-shifting strategy for hypertension control
(TASSH) (this group is denoted TASSH + HIC). This study was an effort to assess the
comparative effectiveness of HIC alone versus the combination of TASSH + HIC on reducing
systolic blood pressure among patients with uncontrolled hypertension in Ghana. Baseline
blood pressure measurements and 12 month follow-up results were collected among subjects,
85\% of whom had 12 month data present
}
\details{
(Ogedegbe G, Plange-Rhule J, Gyamfi J, Chaplin W, Ntim M, Apusiga K, Iwelunmor J, Awudzi KY,
Quakyi KN, Mogavero JN, Khurshid K, Tayo B, Cooper R. 2019).

Licensed under a CC-0 1.0 (Creative Commons) Universal Public Domain Dedication License
}
\keyword{datasets}
