% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.poisreg}
\alias{summary.poisreg}
\alias{print.poisreg}
\title{Summarizing Bayesian Poisson Regression Fit}
\usage{
\method{summary}{poisreg}(object, ...)

\method{print}{poisreg}(x, ...)
}
\arguments{
\item{object}{object of class "\code{poisreg}" (usually, the result of a call to \code{\link{sample_bpr}}).}

\item{...}{further arguments passed to or from other methods.}

\item{x}{object of class "\code{poisreg}" (usually, the result of a call to \code{\link{sample_bpr}}).}
}
\value{
\code{summary.poisreg} returns a list with elements:

\code{formula} : the component from \code{object}.

\code{data} : list with elements the matrix of covariates \code{X} and response variable \code{y}.

\code{prior} : \code{prior$type} from \code{object}.

\code{prior_pars} : prior parameters from \code{object}.

\code{coefficients} : the matrix of coefficient estimantes, standard errors and 95\% credible intervals.

\code{psi2} : if a horseshoe prior is selected, the estimate of the local shrinkage parameter.

\code{len_burnin} : the length of the burn-in used to compute the estimates.

\code{effSize} : the mean effective sample size of the chains used to compute the estimates.
}
\description{
This function is a method for class \code{poisreg}. It prints summary statistics and returns posterior estimates of regression quantities.
}
\details{
The printed output of \code{summary.poisreg} summarizes the main quantities of the fit. 
The first component \code{Call} recaps the type of prior and algorithm used.

\code{Coefficients} is a table of estimated quantities for the regression parameters. The first three columns report the estimated posterior mean, 
standard errors and medians. The last two columns correspond to the lower and upper bounds of the 0.95 credible intervals. 
If the credible interval does not include zero, a star is printed in correspondence of each parameter 
(similarly to the 'significance stars' of \code{\link[stats]{summary.lm}}).
All the estimates are computed discarding the first part of the chain as burn-in (more details are printed in the \code{Algorithm} section).

\code{Algorithm} briefly summarizes the main diagnostics of convergence and efficiency of the algorithm. 
It prints the number of iterations actually used to obtain the estimates, after removing the burn-in and thinning.
If a Metropolis-Hastings algorithm is used, the summary reports the acceptance rate, 
which is the most commonly used indicator to tune the performance of the algorithm, along with the mean effective sample size 
(averaged over all parameters).
If the importance sampler is used, the summary only reports the effective sample size, which is computed as \eqn{\sum_{t} w_t^2 / (\sum_{t} w_t)^2}
(where \eqn{w_t} is the sequence of weights) and is a measure of the efficiency of the sampler.
}
\examples{
# For examples see example(sample_bpr)

}
