% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{infactorOR1}
\alias{infactorOR1}
\title{Inefficiency factor for OR1 model}
\usage{
infactorOR1(x, betadraws, deltadraws, autocorrelationCutoff, verbose)
}
\arguments{
\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.
This input is used to extract column names, if available, and not used in calculation.}

\item{betadraws}{MCMC draws of \eqn{\beta} of size \eqn{(k x nsim)}.}

\item{deltadraws}{MCMC draws of \eqn{\delta} of size \eqn{((J-2) x nsim)}.}

\item{autocorrelationCutoff}{cut-off to identify the number of lags and form batches, default is 0.05.}

\item{verbose}{whether to print the final output and provide additional information or not, default is TRUE.}
}
\value{
Returns a list with components
\itemize{
\item{\code{inefficiencyDelta}: }{It is a vector with inefficiency factor for each \eqn{\delta}.}
\item{\code{inefficiencyBeta}: }{It is a vector with inefficiency factor for each \eqn{\beta}.}
}
}
\description{
This function calculates the inefficiency factor from the MCMC draws
of \eqn{(\beta, \delta)} for OR1 model (ordinal quantile model with 3 or more outcomes). The
inefficiency factor is calculated using the batch-means method.
}
\details{
Calculates the inefficiency factor of \eqn{(\beta, \delta)} using the batch-means
method based on MCMC draws. Inefficiency factor can be interpreted as the cost of
working with correlated draws. A low inefficiency factor indicates better mixing
and efficient algorithm.
}
\examples{
set.seed(101)
data("data25j4")
y <- data25j4$y
xMat <- data25j4$x
k <- dim(xMat)[2]
J <- dim(as.array(unique(y)))[1]
b0 <- array(rep(0, k), dim = c(k, 1))
B0 <- 10*diag(k)
d0 <- array(0, dim = c(J-2, 1))
D0 <- 0.25*diag(J - 2)
output <- quantregOR1(y = y, x = xMat, b0, B0, d0, D0,
burn = 10, mcmc = 40, p = 0.25, tune = 1, verbose = FALSE)
betadraws <- output$betadraws
deltadraws <- output$deltadraws
inefficiency <- infactorOR1(xMat, betadraws, deltadraws, 0.5, TRUE)

# Summary of Inefficiency Factor:

#             Inefficiency
# beta_1        1.1008
# beta_2        3.0024
# beta_3        2.8543
# delta_1       3.6507
# delta_2       3.1784

}
\references{
Greenberg, E. (2012). “Introduction to Bayesian Econometrics.” Cambridge University
Press, Cambridge. DOI: 10.1017/CBO9780511808920
}
\seealso{
pracma, \link[stats]{acf}
}
