% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data75j4}
\alias{data75j4}
\title{Simulated data from the OR1 model for \eqn{p = 0.75} (i.e., 75th quantile)}
\usage{
data(data75j4)
}
\value{
Returns a list with components
\item{\code{x}: }{a matrix of covariates, including a column of ones.}
\item{\code{y}: }{a column vector of ordinal outcomes.}
}
\description{
Simulated data from the OR1 model for \eqn{p = 0.75} (i.e., 75th quantile)
}
\details{
This data contains 500 observations generated from a quantile
ordinal model with 4 outcomes at the 75th quantile (i.e., \eqn{p = 0.75}).
The model specifics for generating the data are as follows: \eqn{\beta = (-4, 5, 6)}, X ~ Unif(0, 1), and
\eqn{\epsilon} ~ AL(\eqn{0, \sigma = 1, p = 0.75}). The cut-points \eqn{(0, 2, 4)} are used to classify the
continuous values of the dependent variable into 4 categories, which form the ordinal outcomes.
}
\references{
Rahman, M. A. (2016). `"Bayesian Quantile Regression for Ordinal Models."`
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939

Yu, K., and Zhang, J. (2005). `"A Three-Parameter Asymmetric Laplace Distribution."`
Communications in Statistics - Theory and Methods, 34(9-10), 1867-1879. DOI: 10.1080/03610920500199018
}
\seealso{
\link[MASS]{mvrnorm}, Asymmetric Laplace Distribution
}
\keyword{datasets}
