% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/braidReport.R
\name{runBraidAnalysis}
\alias{runBraidAnalysis}
\alias{runBraidAnalysis.formula}
\alias{runBraidAnalysis.default}
\title{BRAID Surface Analysis}
\usage{
runBraidAnalysis(
  formula,
  data,
  defaults,
  weights = NULL,
  start = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL,
  useBIC = TRUE,
  ...
)

\method{runBraidAnalysis}{formula}(
  formula,
  data,
  defaults,
  weights = NULL,
  start = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL,
  useBIC = TRUE,
  ...
)

\method{runBraidAnalysis}{default}(
  formula,
  data,
  defaults,
  weights = NULL,
  start = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL,
  useBIC = TRUE,
  ...
)
}
\arguments{
\item{formula}{Either an object of class \code{formula} such as would be provided
to a modeling function like \code{\link[stats:lm]{stats::lm()}}, or a width-2 numeric array vector
of concentration pairs (including 0 or Inf).  A formula should specify a
single output as a function of two inputs, eg. \code{activity ~ conc1 + conc2}.}

\item{data}{If \code{forumula} is a symbolic formula, a data frame containing the
specified values. If \code{formula} is a numeric array of concentrations, a
numeric vector of response values, the same length as the number of rows of
\code{formula}.}

\item{defaults}{Default minimal and maximal effect values used to fix effect
parameters during model selection.}

\item{weights}{A vector of weights (between 0 and 1) the same length as
the data which determines the weight with which each measurement
will impact the the sum of squared errors.  Weights will be multiplied by
errors \emph{before} squaring.  If \code{NULL} (the default) all weights will be set
to 1. Can be a numeric vector, or the name of a column in \code{data} if \code{formula}
is a symbolic formula}

\item{start}{A BRAID parameter vector specifying the first guess where the
non-linear optimization should begin.  May be a length 7, 8, or 9 vector,
though a full length vector is always preferable.  If \code{NULL} (the default),
it will be estimated from the data.}

\item{direction}{Determines the possible directionality of the BRAID
model.  If 0 (the default) no additional constraints are placed on the
parameters.  If greater than 0, the fitting will require that the maximal
effects are all \emph{greater} than or equal to the minimal effect.  If less
than 0, the fitting will require that all maximal effect is \emph{less} than or
equal to the minimal effect.}

\item{lower}{A numeric vector of lower bounds on the fitted parameter values.
May be the same length as the number of fitted parameters, or a full,
length-9 vector. Missing or unspecified lower bounds may be included as \code{NA}
or \code{Inf}; if unspecified, lower bounds on the first five parameters (IDMA,
IDMB, na, nb, and kappa) will be automatically estimated from the data.
Bounds on the minimal and maximal effect parameters however (E0, EfA, EfB,
and Ef) will be assumed to be infinite unless specified.  A value of \code{NULL},
the default, will be treated as all lower parameter bounds being
unspecified.}

\item{upper}{A numeric vector of upper bounds on the fitted parameter values.
Used in the same way as \code{lower}.}

\item{useBIC}{If \code{TRUE} (the default), the best (read: most parsimonious)
model will be selected from all tested models using the Bayesian information
criterion (Schwarz 1978).  If \code{FALSE} the function will follow the convention
of earlier versions of the \code{braidrm} package and use the Akaike information
criterion (Akaike 1974).}

\item{...}{Additional parameters to be passed to \code{\link[braidrm:findBestBraid]{braidrm::findBestBraid()}}}
}
\value{
An object of class \code{braidAnalysis}, containing the following values:
\itemize{
\item \code{concs}: a width-two array containing the two tested doses for each
measurement
\item \code{act}: a numeric vector with as many values as \code{concs} has rows,
containing the measured values for each measurement
\item \code{weights}: a numeric vector of weights, the same length as \code{act},
specifying the weight given to each measurement in fitting.  All weights are
1 by default
\item \code{braidFit}: a fit object of class \code{braidrm} containing the best-fit BRAID
surface according to the given constraints
\item \code{hillFit1}: If the given data contains measurements of the first drug in
isolation, those measurements are fit using \link[basicdrm:findBestHillModel]{basicdrm::findBestHillModel};
the results of this analysis are stored as an object of class \code{hillrm} as
\code{hillFit1}. If no such measurements are found, this will be \code{NULL}
\item \code{hillFit2}: the corresponding fit for measurements of the second drug
alone, if they are included; \code{NULL} otherwise
}
}
\description{
Performs a convenient pre-built set of BRAID and dose-response analysis
tasks
}
\examples{
surface <- synergisticExample

analysis <- runBraidAnalysis(measure~concA+concB, surface, defaults=c(0,1))

names(analysis)
}
